﻿# The script of the game goes in this file.

# Declare characters used by this game. The color argument colorizes the
# name of the character.

init python:
    import math

python:
    def set_bit(value, bit_index):
        return value | (1 << bit_index)

python:
    def bubble_sort_dict_by_value(d):
        items = list(d.items())  # Convert dictionary to list of tuples
        n = len(items)
        for i in range(n):
            for j in range(0, n - i - 1):
                if items[j][1] > items[j + 1][1]:
                    # Swap the elements
                    items[j], items[j + 1] = items[j + 1], items[j]
        return dict(items)

define mp_data = MultiPersistent("nief.org")

define n = Character("Narrator")
define asm = Character("Asmund", image="reporter")
define gro = Character("Eileen", image="fishwife")
define p = Character("Reverand Evohart", image="reverend")
define lum = Character("Lumberyard Worker", image="lumber")
define fsh = Character("Fishmongerer", image="fishmongererer")
define bdfsh = Character("Greedy Fisherman", image="greedyfisher")
define poorwm = Character("Poor Old Woman", image="pooroldwoman")
define fatman = Character("Fat Wealthy Man", image="fatwealthyman")
define sch = Character("Village Historian", image="scholar")
define tem = Character("Cult Priestess", image="temptation")
define tem2 = Character("Cult Priestess", image="witch")
define goon = Character("Goon", image="dockworker")
define tarn = Character("Tarn", image="notexture")
define alice = Character("Alice", image="notexture")
define caleb = Character("Caleb Douglas", image="caleb")
define ellie = Character("Ellie Page", image="ellie")
define gemma = Character("Gemma Emmrich", image="gemma")
define outom = Character("Tom", image="outom")
define ouclarke = Character("Clarke", image="ouclarke")
define oupaulo = Character("Paulo", image="oupaulo")

transform half_size: 
    zoom 0.5 #adjust as required

image side fishwife = Image("fishwife.png", oversample=3, xalign=1.0)
image side reverend = Image("priest.png", oversample=3)
image side dockworker = Image("dockworker.png", oversample=3)
image side reporter = Image("reporter.png", oversample=3)
image side lumber = Image("industrialist.png", oversample=3)
image side greedyfisher = Image("greedyman.png", oversample=3)
image side fishmongererer = Image("fishmongerer.png", oversample=3)
image side pooroldwoman = Image("pooroldwoman.png", oversample=3)
image side fatwealthyman = Image("fatwealthyman.png", oversample=3)
image side scholar = Image("shcolar.png", oversample=3)
image side temptation = Image("temptation.png", oversample=3)
image side notexture = Image("notexture.png", oversample=3)
image side witch = Image("witch.png", oversample=3)
image side gemma = Image("gemma.png", oversample=3)
image side ellie = Image("ellie.png", oversample=3)
image side caleb = Image("caleb.png", oversample=3)
image side ouclarke = Image("OUclarke.png", oversample=3)
image side oupaulo = Image("OUpaulo.png", oversample=3)
image side outom = Image("OUtom.png", oversample=3)
image sun = Image("sun.png", oversample=2)
image ladyofweeds = Image("queenofweedsfull.png", oversample=2)
image bg dock = Image("bg dock.jpg")
image bg path = Image("bg path.jpg")
image bg church = Image("bg church.jpg")
image bg fishmogerer = Image("bg fishmonger.jpg")
image bg grocier = Image("bg grocier.jpg")
image bg lumberyard = Image("bg lumberyard.jpg")
image bg altar = Image("bg altar.jpeg")
image bg church = Image("bg church.jpg")
image bg darkswamp = Image("bg darkswamp.jpg")
image bg forest = Image("bg forest.jpeg")
image bg swamp = Image("bg swamp.jpeg")
image bg cave = Image("bg cave.jpg")
image bg doctor = Image("bg doctor.jpg")
image bg blackhole = Image("bg blackhole.jpg")

default intro_fsh = False
default intro_lum = False
default intro_gro = False

default sin_lust = 1
default sin_pride = 1
default sin_greed = 1
default sin_envy = 1
default sin_gluttony = 1
default sin_wrath = 1
default sin_sloth = 1
default ssin_lust = 0
default ssin_pride = 0
default ssin_greed = 0
default ssin_envy = 0
default ssin_gluttony = 0
default ssin_wrath = 0
default ssin_sloth = 0
default sselect1 = 0
default sselecta = 0
default sselect2 = 0
default sselectb = 0
default sselecth = 0
default sselecti = 0
default sselectj = 0
default sselectk = 0

default day = 0
default weekday = 0
default segment = 0
default select = 0
default holding = 0

default vege = 4
default meat = 4
default lumb = 2
default mone = 0
default clea = 0
default laun = 0
default spar = 0
default squa = 0
default grav = 0
default mbui = 0
default fenc = 0
default pape = 0
default rubb = 0
default wood = 0
default raw_wood = 0
default mood = 50
default madn = 0
default heal = 50
default laud = 0
default rune = 0
default lant = 0
default sun.xl = 0.0
default weda = ""
default WEATHER = ""
default alphamenu = 0
## cultist
default lfai = 25
## faithful
default gfai = 25
## Total living population of island
default pops = 500

## quest booleans
default knows_laud = 0
default knows_finikson = 0
default knows_buildings = 0
default knows_buildings_museum = 0
default knows_runes = 0
default knows_tunes_loc = 0
default knows_lady_of_weeds = 0
default knows_catacombs = 0
default knows_norse_script = 0
default knows_cave1 = 0
default knows_shovel = 0
default knows_lantern = 0
default knows_cliffrit1 = 0
default knows_pictures = 0

default tantrum_alice = 0

default follower_alice = 0

default skill_mushroom_edible = 0
default skill_mushroom_poisonus = 0
default skill_mushroom_psych = 0
default skill_mushroom_health = 0

default skill_forage_edible = 0
default skill_forage_poisonus = 0
default skill_forage_psych = 0
default skill_forage_health = 0

default skill_history = 0
default skill_runes = 0
default skill_chemistry = 0

default apothecary = {"ttail" : 0}
default storyflags = {"ego1" : 0 , "egodeath" : 0}

label splashscreen:

    $ renpy.movie_cutscene('ptitle1.ogv')

    return

# The game starts here.

screen sun(x): 
    add "sun": 
        xalign x 
        yalign 0.0


label start:
    play music [ "T1 Whispers of Serenity.mp3", "T2 Whispers of Solitude.mp3", "T3 Whispers of Silence.mp3", "T4 Whispers of Shadows.mp3", "T5 Whispers of Industry.mp3"] loop fadeout 1.0 fadein 1.0 volume 0.25
    show screen sun(0.0)
    python:
        """
    scene bg doctor
    n "The boat suddely lurches under you and you startle awake. You didn't intend to fall asleep... but you did. The man across from you chuckles. What was his name? Doctor... something."
    n "\"Good morning, Reverend! I hope your rest was worthwhile. We're not there yet though...\" You nod. \"As I said before, I'm studying sociology. Mind if I ask you a few questions?\" You nod, again."
    menu:
        "When you were a child, what did you do first?"
        "Walk. (+Athletics)":
            pass
        "Talk. (+Persuasion)":
            pass
        "Fight. (+Melee)":
            pass
    menu:
        "\"Interesting! Everyone has a different answer for that one. Next question - what was your best subject in school?\""
        "English and Languages. (+Persuasion)":
            pass
        "Maths and Sciences. (+Bonuses when building, repairing)":
            pass
        "Ecological Sciences. (+Bonuses to forest, some nature events.)":
            pass
        "Physical Education. (+Athletics)":
            pass
        "Culinary Arts. (+Bonuses to cooking, free ingrediants)":
            pass
    n "\"Excellent! I enjoyed something similar during my formative years. Now, easy ones are done. We get to something a bit more... meaty.\""
    menu:
        "\"You have purchased a coat from a local tailor, and see that the man has given you too much change. It's lucky, because you are short on rent this month. What do you do?\""
        "Return the change, and ask the tailor if he knows of anyone looking for laborers.":
            pass
        "Return the change, but don't mention it. The problem will solve itself soon enough.":
            pass
        "Keep the change, but share some of it with the local needy.":
            pass
        "Keep the change.":
            pass
    n "\"Ok! The Boarder you have on to help pay the bills has missed another rent check. He said it'll be a little late, but he was also short last month.\""
    menu:
        " What do you do?"
        "Everyone faces hard times. Cut him some slack.":
            pass
        "Everyone faces hard times. As long as he pays back with interest, we're good.":
            pass
        "He owes one hour of community service for every dollar he's short. Make him work it off.":
            pass
        "Inform him he needs to move, and provide a invoice for what he owes":
            pass
        "He's been in breach of the agreement three times in a row. Chuck is stuff out onto the lawn.":
            pass
    n "\"Interesting! My professor always said you could tell a lot about people by what they do when there's a power dynamic. Ok, last question.\""
    n "\"You are the king of a magical kingdom, but your divinator has predicted famine. You can't use magic to feed people, but you CAN use magic to make them less hungry.\""
    n "\"Hundreds will still die, but at least they won't feel the pain.\""
    menu:
        "What do you do?"
        "Tell the wizard to cast the anti-hunger spell":
            pass
        "Double the pesants effort, even if we have to work them to death":
            pass
        "Arm the pesants and invade one of our neighbors":
            pass
        "Kill all the oldest and frailest of the pesants, to make sure the strong survive":
            pass
    n "He nods.\" Last one's a tricky one. When someone asked me, I chose to arm the pesants. We got into a long argument about peasant revolts! Ha, ha. Anyways, I think this is your stop.\""
    n "Indeed, it is. You beg your leave, grab your stuff and step out onto the deck."
        """
    scene bg dock
    n "The boat lurches up to the ancient dock, and you make your haste to get off. It was not a long ride from the shore to the isle, but you've never quite had your sea legs. An old man stands with his hands stuffed in the pockets of his wool coat."
    
    asm "\"Aye. You must be the Reverend. Replacing Reverand Evohart, are you? Such a sad tale. Well, we need to be getting you up to the church then, so he can be off. Come now.\""
    scene bg path
    call walking from _call_walking
    n "The hill is gentle as it slopes up, and you pass row upon row of older cabins, many of which have residents sitting out on old rocking chairs. The weather here is pleasant enough to be outdoors."
    call walking from _call_walking_1
    n "As you climb you pass several cleared out areas, well kept and floored with stone. Probably for some pagan ritual or another."
    call walking from _call_walking_2
    n "You follow the little trail up the hill to the church standing on the hill. As you approach the building, the old man opens the door and steps to the side."
    call walking from _call_walking_3
    n "You nod to him and enter, seeing a man in robes of the cloth, going through several pockets in a suitcase. He looks up to you as you enter."

    scene bg church
    
    p "\"Ah Reverend!\" He exclaims. \"I was hoping to meet with you before I take off. The duration of my leave is a year, and not a day more, and as you guessed, you will be taking care of my flock in my stead.\""
    p "\"Treat the villagers here with kindness, and do not judge them for how they look or act. It is their burden, and one you will learn of soon enough. You are not in danger, as long as you follow a few simple rules.\""
    p "\"Rule 1: You're not here to save anyone. You must simply preserve the balance of this town, nothing more. Provide them comfort when they need it, but do not sway them. You will need the balance.\""
    p "\"Rule 2: Buy fish only from Patrick Okitu, or if he is indisposed, Igor Iwa. It will help you preserve your body.\""
    n "\"Wait, what? Preserve my body?\" you ask."
    p "\"No time. just heed my words.\" He curtly responds."
    p "\"Rule 3: If you notice anything… environmental… that seems concerning, lock the church and do not hold sermon. Spend the time studying, praying, and preparing for the next week.\""
    p "\"Rule 4: Only do your shopping on Mondays. Speak to your paritioners, listen to their concerns, and it will help you target your sermon for Sunday. Remember - preserve, not convert.\""
    p "\"Rule 5: You have 10 pence per week for groceries and supplies. If you are meeting your paritioners needs, they will grant you more, that you can use as you see fit. It will be up to you to maintain the church, the graveyard, and provide support to the poor.\""
    p "\"Rule 6: There are always deeper mysteries, and we are not here to solve them. Stick to your own.\""
    p "\"So, that's that then. Oh no, do not think of this as doom and gloom, and Asmund here will be able to answer any questions you have. Feel free to rely on him. He has been a good friend to me."
    p "Take care of the grounds, the dead, and the paritioners, and you will be all right. Nothing you have not done before.\""
    play sound "heavy bag rummage a.wav"
    n "You hear the sounds of several boxes being moved, and through the door you can see several men from the docks walking back down the hill."
    p "\"That will be your stuff. I've taken the liberty of procuring some supplies for you to help spruce this place up a bit in my absence. Keep an eye on the graveyard - the storms tend to damage it more than the rest of the property." 
    p "There is an axe and the tools to mill and plane lumber yourself, or you can purchase it from the town at your convenience. There is also a reference library in the office, but I'm sorry to say I have not had much time to peruse it.\""
    play sound ['door close.wav', "ShoeA.wav", "ShoeB.wav", "ShoeA.wav"]
    n "He looks at the workmen outside, tips his hat to you, grabs his suitcase, and leaves. Asmodeus hovers in the doorway for a minute, then closes it. You are now alone."
    menu:
        "{i}I've noticed that this is the first time you're playing. Would you like a short tutorial?{/i}"
        "Yes":
            n "{i}Welcome! Thanks for trying our demo! If you have any feedback, please send it to feedback@nief.ca .{/i}"
            n "{i}You will be playing as a local priest in a small fishing village. Each day is seperated into 6 different segments, where you can move about the world and interact with locals.{/i}"
            n "{i}Every Sunday you have the option to perform Mass, which will convert locals and strengthen your bonds to the community.{/i}"
            n "{i}For this demo, we have two different systems: The Omni Menu and the Open World. The button to switch between them is at the bottom of the list.{/i}"
            n "{i}This game remembers what you do between playthroughs, and some later events may depend on what you did last run.{/i}"
            n "{i}To start off with, your goal should be to survive to the 90 day Lady of Weeds event. Explore, learn, read books, and see if you can find where the Lady came from.{/i}"
            n "{i}Every 30-60 days there will be a Tantrum by the Lady of Weeds, that will require a ritual to stop it's effects. Every tantrum has multiple possible solutions, so try leveraging all the people you meet and things you find.{/i}"
            n "{i}If you think you're getting to popular, try skipping a mass or two. The people will understand. Remember, it's all about balance.{/i}"
            n "{i}In the full game you will be able to fully deal with the Lady of Weeds, but for this demo, just try to survive her wrath.{/i}"
            n "{i}The more sermons you write throughout the week based on the things that you've seen, the more effective mass will be on Sunday.{/i}"
            n "{i}You can recruit volenteers for persistent bonuses. Performing chairty acts, such as feeding the poor in the stacks, is also a great way to balance things.{/i}"
            n "{i}The Grove of Weeds, the cult of the Lady of Weeds, in general will not be antagonistic untill after you've threatened them in some major way.{/i}"
            n "{i}You... kinda got to be really trying to have this happen. The full game will have more opertunities for espionage.{/i}"
            n "{i}Another feature that will be in the full game is that anyone can die by the hands of the Lady of Weeds. If Eileen is dead, someone will take her place.{/i}"
            n "{i}In some scenarios, this may offer you unique routes to achieving different endings and goals.{/i}"
            n "{i}Villagers will sometimes bring you problems. It's up to you to decide if and how you deal with them.{/i}"
            n "{i}There are only 500 villagers. They can die, either from fighting each other, the sea, or the spite of the Lady of Weeds.{/i}"
            n "{i}Keep your eyes out for any that may be off the beaten track.{/i}"
            n "{i}Good luck! We'll check in with you again when it's time for your first Tantrum.{/i}"
        "No":
            pass
    jump shopping
    label gameend:
    $ mp_data.patd_restart += 1
    $ mp_data.save()
    # This ends the game.

    return

label door_and_walking:
    play sound ['door close.wav', "ShoeA.wav", "ShoeB.wav", "ShoeA.wav"]
    return

label walking:
    play sound ["ShoeA.wav", "ShoeB.wav", "ShoeA.wav"]
    return

label trigger_events:
    if segment is 0:
        if day is 30:
            n "You wake up to a horrible smell. You check your residence and no food has gone off, but there is still a horrifying rotten smell somewhere."
            n "When you step outside, it gets so much worse. The closer you get to the cliffside, the worse it gets. Looking over the side, you almost throw up."
            n "The rocks below are covered with the rotten and splattered remains of fish. It's everywhere. you can see the beaches are covered all the way to the north and south."
            n "Gangs of stack residents are currently filling buckets and hacking corpses, getting the beach clean towards town, and to the north you can see a few people clearing the wild beaches."
            n "You head down and help clean. The people seem... worried. This is a bad omen. {i} Your mood suffers... {/i}"
            $ mood -= 5
        if day is 31:
            n "The smell from yesterday is almost gone. Seems the tides cleaned up what you could not. {i}Your mood improves. {/i}"
        if day is 45:
            n "You wake up to a cacophany out in the church. Someone is hammering on the main door. Loudly. You throw on a robe and rush through to the church, opening it."
            n "Standing huddled and wrapped in a ratty shawl stands a young woman with black hair, maybe 19 or 20. Her face is an expression of anquish."
            menu:
                "{i}Congradulations! Welcome to your first Lady of Weeds Tantrum! Would you like an explanation on how this works?{/i}"
                "Yes":
                    n "{i}Every 30-60 days or so, the Lady of Weeds will throw a tantrum and make a demand from her worshipers. Some of them you will be directly involved in like here, and others you will have to fight to discover.{/i}"
                    n "{i}Your first event will always be this one - however, the next one will be chosen randomly. 30 days before you will always get a omen event that will give you an idea of what you're dealing with.{/i}"
                    n "{i}Sometimes, you might need to adventure in town or the woods to find the event.{/i}"
                    n "{i}Fifteen days before the event, you'll get a chance to influence the event. There's often a easy way to deal with it(In this case, it's turning away Alice), but it will have weighty short term concequences.{/i}"
                    n "{i}There will always be multiple ways to deal with every event. It'll be up to you to figure out how.{/i}"
                    menu:
                        "{i}Would you like a hint on how to solve this event?{/i}"
                        "Yes":
                            n "{i}The first element is a ritual book in your bookcase, and the second regards the Historian. Make sure you rescue Alice.{/i}"
                        "No":
                            n "{i}Good luck then! Happy playing!{/i}"
                "No":
                    pass
            alice "\"Reverend! Oh god, please let me in. Quickly! Quickly! They can't find me here!\" She wispers."
            menu:
                "What do you do?"
                "Let her in?":
                    n "You step asside and she rushes in, slamming the door behind her and pressing up against it hard."
                    alice "\"Listen - I'm asking for asylum. They're going to feed me to her. My name is Alice and my father is a member of the Grove of Weeds. They think that if they don't, she's going to kill everyone.\""
                    alice "\"You need to protect me. Gods all about forgiveness and love, right? I don't want to be damned because of my fathers beliefs.\""
                    n "There is suddenly a banging on the door."
                    tarn "\"Alice! Alice, it's Tarn. It's Dad. Look, I know you're in there. You need to come out, Alice. We don't have enough time to find someone else. Alice, I need you to think of your mom and your sisters. They're going to die if you don't do this.\""
                    n "Alice's lips start to tremble, and her eyes well up with tears, but she presses harder on the door."
                    tarn "\"If you don't come with me now, everyone's going to die. You've seen her. You know what she can do. Please Alice, it's for the greater good. Please. Please.\" He starts sobbing."
                    menu:
                        "What do you do?"
                        "Send Alice to hide in the Rectory":
                            n "You press against the door, and point to your residence. Alice nods, and she bolts for the door, opening and closing it quietly. After she's gone, you open the door a crack."
                            n "\"Hi Tarn.\" You say. \"What can I do for you?\""
                            n "His face is puffy. He's been crying. His eyes are filled with sorrow and rage."
                            tarn "\"Respectfully, Reverend, you need to give my daughter to me. Now.\" He's still fighting back tears."
                            n "\"I can't do that, Tarn.\" You say. \"She's old enough to be a woman, and she has asked for asylum.\" You notice several feet behind Tarn are two of the layabouts from town."
                            n "Tarn strikes the door and tries to push his way in, but you stand fast."
                            tarn "\"You need to let me in priest. She's MY daughter.\" There's something else in his eyes too... hope?"
                            n "\"I can't do that Tarn. It's against the rules. You and you're buddies are part of the Grove, right? What would your leader think of it?\" He takes a step back. The other men have heard you, and back off down the path."
                            n "He wispers something... you think he said thank you..."
                            n "You close the door and bar it, and then move back to your residence."
                            n "Alice is huddled in the corner. You try and comfort her, but you know that there's nothing much you can say. You serve her some soup, and hope it helps."
                            $ tantrum_alice = 1
                            return
                        "Open the door and allow Tarn to take Alice":
                            n "You move Alice and pull the door open. Three men barge in, grab her, and leave. Not a word."
                            n "The looks you get though. They wanted you to protect her, you think."
                            m "Or is that just your own guilt?"
                            ## clear out piety and hardcore faithful
                            return
                "Turn her away?":
                    n "This reeks of the cult. You think back at what your predescessor said."
                    n "\"What is this about?\"You ask."
                    n "\"I can't tell you like this and we don't have time. Please!\""
                    n "Too many unanswered questions. You secure the doors. She screams, and in a moment there is a loud thump on the door, then the screaming fades away."
                    n "You don't know if this was the right descision."
                    ## clear out piety and hardcore faithful
                    return
        if day is 75:
            n "You are awoken by a bright light passing through the window of your abode early in the morning. Sleepy, stumbling, you get up and go outside to take a better look."
            n "The light is coming from far out to see... you can see a lighthouse straddling a few rocks. It has been dark until today. The light however is shining brightly, bathing the shore, then the city in a spotlight."
            n "Finally, it washes over the curch and you. You feel... seen."
            n "This can't be good."
        if day is 90:
            jump endingw

label main_loop:
    label advance:
        $ segment = segment + 1
        if segment is 1:
            show screen sun(0.2)
        if segment is 2:
            show screen sun(0.4)
        if segment is 3:
            show screen sun(0.6)
        if segment is 4:
            show screen sun(0.8)
        if segment is 5:
            show screen sun(1.0)
        if segment is 1 or segment is 4:
            jump makefood
        label makefooddone:
        if segment >= 6:
            $ segment = 0
            show screen sun(0.0)
            $ weekday = weekday + 1
            jump dream
            label dreamend:
            if weekday >= 8:
                $ weekday = 0
                $ sin_envy = 0
                $ sin_gluttony = 0
                $ sin_greed = 0
                $ sin_lust = 0
                $ sin_pride = 0
                $ sin_sloth = 0
                $ sin_wrath = 0
            $ day = day + 1
            if weekday is 0: 
                $ weda = "monday"
            if weekday is 1: 
                $ weda = "tuesday"
            if weekday is 2: 
                $ weda = "wednesday"
            if weekday is 3:
                $ weda = "thursday"
            if weekday is 4: 
                $ weda = "friday"
            if weekday is 5: 
                $ weda = "saturday"
            if weekday is 6: 
                $ weda = "sunday"
            n "The morning of [weda], day [day] dawns."
    label checkending:
        if day >= 364:
            jump endingf
        if day is 60 and tantrum_alice is 1:
            jump endingw
        if day is 60 and tantrum_alice is 2:
            call tantrum_alice_end from _call_tantrum_alice_end
        if mood <= -100:
            jump endingz
        if heal <= -100:
            jump endingy
        if laud >= 30:
            jump endingx
    label followers_action:
        $ select = renpy.random.randint(1, 5)
        if select is 1 and segment <= 1:
            call follower_alice_action from _call_follower_alice_action
    label no_advance:
        if segment is 0 and weekday is 0:
            $ mone = mone + 10
            jump shopping
        elif segment is 0 and weekday is 7:
            jump sermonday
        else:
            jump segment_choice

label segment_choice:
    scene bg church
    if alphamenu is 1:
        jump travel_priestacc
    menu:
        "For the next part of the day I will..."
        "...go shopping." if (segment is 0 or segment is 1) and mone >= 1:
            call door_and_walking from _call_door_and_walking
            jump shoppingeach
        "...explore the town." if segment is 0 or segment is 1 or segment is 2:
            call door_and_walking from _call_door_and_walking_1
            jump events
        "...explore the woods." if segment is 0 or segment is 1 or segment is 2:
            call door_and_walking from _call_door_and_walking_2
            jump woods
        "...harvest some wood."  if segment is 0 or segment is 1 or segment is 2:
            call door_and_walking from _call_door_and_walking_3
            jump chopwood
        "...visit someone in town."  if (segment is 0 or segment is 1 or segment is 2) and knows_buildings >= 1:
            call door_and_walking from _call_door_and_walking_4
            jump govisit
        "...mill some boards." if raw_wood >= 2:
            call door_and_walking from _call_door_and_walking_5
            jump mill
        "...work on your sermon." if spar <= 10:
            call door_and_walking from _call_door_and_walking_6
            jump sermon
        "...repair the church property." if (grav >= 1 or mbui >= 1 or fenc >= 1) and wood > 0:
            call door_and_walking from _call_door_and_walking_7
            jump cproperty
        "...clean the church." if clea >= 1:
            call door_and_walking from _call_door_and_walking_8
            jump clean
        "...do miscellaneous upkeep taks." if laun >= 1:
            call door_and_walking from _call_door_and_walking_9
            jump laundry
        "...read from the library.":
            call door_and_walking from _call_door_and_walking_10
            jump library
        "...feed the poor." if vege >= 2 and meat >= 2:
            if vege <= 8 or meat <= 8:
                menu:
                    "Are you sure? You may not have enough food to make it till next week."
                    "No.":
                        jump segment_choice
                    "Yes.":
                        pass
            call door_and_walking from _call_door_and_walking_11
            jump feedthepoor
        "ALPHA: Switch to the wander menu system":
            $ alphamenu = 1
            jump segment_choice
    jump no_advance

label makefood:
    if segment is 1:
        if vege <= 0 and meat <= 0:
            n "You are out of food. This is not good."
            $ heal = heal - 10
            $ mood = mood - 5
        elif vege <= 0 or meat <= 0:
            n "Shoot. Your pantry is getting low."
            $ mood = mood - 1
            if meat <= 0:
                $ vege = vege - 1
                n "You're out of meat."
            else:
                $ meat = meat - 1
                n "You're out of vegetables and staples."
        else:        
            $vege = vege - 1
            $meat = meat - 1
    if vege <= 0 and meat <= 0:
        n "You have nothing left to eat."
        jump makefooddone
    else:
        $ select = renpy.random.randint(1, 13)
        if select is 1:
            n "You arrive back at your quarters, and make yourself a nice sandwich. Yum!"
        if select is 2:
            n "You make some oatmeal and add some smoked fish to it. Fills the spot."
        if select is 3:
            n "You cook up a simple fish soup. Healty!"
        if select is 4:
            n "You use some cooked fish, some cream cheese, and make some stuffed mushrooms. Excelcior!"
        if select is 5:
            n "You break into your Gravlax. You've been waiting for this!"
        if select is 6:
            n "You sear some white fish and have it with boiled new potatoes. Amazing!"
        if select is 7:
            n "You cook up some potatoes, mash them, and mix them with some canned tuna, and fry it into several cakes. Scrumptious!"
        if select is 8:
            n "You make up a simple mustard sauce and pan fry several fillets in it. Gorgeous!"
        if select is 9:
            n "You set a simple stew up with some root vegetables. It tastes delicious!"
        if select is 10:
            n "You stew some fish, lentils, and various spices to create a fragrant and filling stew!"
        if select is 11:
            n "You make a simple pie with fish, make a creame based sauce, and cook it with a topping of cheesy potatoes. Fantastic!"
        if select is 12:
            n "You make a simple flaky crust, and make several sardine turnovers with garlic and onion. Portable!"
        if select is 13:
            n "You make a sardine salad with boiled potatoes, onions, and a vinagrette dressing. Refreshing!"
        if select is 14:
            n "You flake some white fish, and make yourself a nice omellete. Get those gains!"
        if select is 15:
            n "You fry up a fillet, make some mustard, add a pickle, and make it a sandwich! Fish sandwich, ba dump, ba dump..."
        if select is 16:
            n "You're scrambling up an egg and figure, why not fish? You add some. It's good."
        if select is 17:
            n "You batter and fry a fish fillet, and sautee up some vegetables. Homey!"
        if select is 18:
            n "You make a paste out of fish, herbs, and spices. You then apply it to crackers. Finger licking good!"
        jump makefooddone

label sermonday:
    $ sselect1 = sin_lust
    $ sselecta = 1
    if sin_pride >= sselect1:
        $ sselect1 = sin_pride
        $ sselecta = 2
    if sin_greed >= sselect1:
        $ sselect1 = sin_greed
        $ sselecta = 3
    if sin_envy >= sselect1:
        $ sselect1 = sin_envy
        $ sselecta = 4
    if sin_gluttony >= sselect1:
        $ sselect1 = sin_gluttony
        $ sselecta = 5
    if sin_wrath >= sselect1:
        $ sselect1 = sin_wrath
        $ sselecta = 6
    if sin_sloth >= sselect1:
        $ sselect1 = sin_sloth
        $ sselecta = 7
    if sselecta != 1:
        $ sselect2 = sin_lust
        $ sselectb = 1
    if (sselecta != 2) and ( sin_pride >= sselect2):
        $ sselect2 = sin_pride
        $ sselectb = 2
    if ((sselecta != 3) and ( sin_greed >= sselect2)):
        $ sselect2 = sin_greed
        $ sselectb = 3
    if ((sselecta != 4) and ( sin_envy >= sselect2)):
        $ sselect2 = sin_envy
        $ sselectb = 4
    if ((sselecta != 5) and ( sin_gluttony >= sselect2)):
        $ sselect2 = sin_gluttony
        $ sselectb = 5
    if (sselecta != 6) and ( sin_wrath >= sselect2):
        $ sselect2 = sin_wrath
        $ sselectb = 6
    if (sselecta != 7) and ( sin_sloth >= sselect2):
        $ sselect2 = sin_sloth
        $ sselectb = 7
    n "You wake up bright and early, and after a quick breakfast, take a look outside at the weather."
    n "It's a bright sunny day today. Perfect for an indoor sermon."
    menu:
        "Do you want to still have a sermon today?"
        "Yes":
            n "You spend the first part of the morning tidying up, take a quick warm bath, and dress in your best attire."
            n "You light all the candles, prepare your sermon on the pulpit, then open the doors."
            n "A stream of townspeople come in, one after the other. You greet them warmly. You can see a lot of familiar faces."
            ## add a selector here for outreach(convert hardcore cultists), regular sermon(get faithful), and fire and brimstone(convert faithful to hardcore faithful)
            if sselecta == 1:
                n "You start railing against lust. You give an overview of what it does to your life, your family, your comunnity."
                n "You describe how the chasing of the flesh leads you away from god, and give a somewhat convincing story about a neglectful shepard loosing their flock."
            elif sselecta == 2:
                n "You start railing against pride. How it forces everyone away, how it props one up on a rickety tower."
                n "You follow up with the story of a sickly schollar who refuses everyone's help, until one day he dies alone, too sick to move."
                n "Very morbid."
            elif sselecta == 3:
                n "You start railing against greed. How you withdraw to your dragons hord while the universe suffers around."
                n "You tell a story about a wealthy investor who makes his money bankrupting companies he invests in..."
                n "... untill he dies at the hands of a mob. A little morbid, but poigniant."
            elif sselecta == 4:
                n "You start railing against envy. How it corrupts your relationships and turns everyone against you."
                n "You speak of two neighbors, one that has a slightly more attractive spouse, slightly prettier house, slightly better boat."
                n "The one man spends all his time fuming about how his neighbor gets all the breaks, never loving what he has, untill finally his wife moves back in with her mother and he is left alone."
                n "There are a few looks in the audience between couples."
            elif sselecta == 5:
                n "you start railing against gluttony. You give details on how everyone suffers from a gluttons bequest."
                n "You weave a tale about a rich man who's gluttony means that he became so heavy he had to be removed in pieces."
                n "Why are you so morbid this week?!"
            elif sselecta == 6:
                n "You start railing against wrath. How harm begets harm and leads everyone to a spiral down to hell."
                n "You tell the tale of a fisherman who caught his spouse cheating then killed her and her lover."
                n "This leads to a trail of destruction leading to him dying at the end, when otherwise he would have been fine, but sad."
                n "Another morbid one. Why are you like this?"
            elif sselecta == 7:
                n "You start railing against sloth. How the more you don't fix, the worse your life will become."
                n "You tell the story of a lazy woodcutter with a broken stove pipe, and how each evening it would list a little more, but he was too tired to fix it."
                n "One night, it fell, and he died by being burned alive. So edgy. You should write some goth poetry."
                n "You shake the thought from your head and continue."
            if squa <= 25:
                n "You doubt it was enough to sway anyone, but at least one person looked impressed."
            elif squa <= 50:
                n "Once you stop speaking there are a few looks, and you feel you might have reached a couple of people."
            elif squa <= 75:
                n "As soon as you stop, there is some chatter in the crowd. One couple looks almost about to come to blows, but everyone keeps their cool. Sounds like a few people listened."
            elif squa <= 100:
                n "There are a lot of people nodding. It seems you've gotten through to quite a few people."
            else:
                n "The people hang on your every word. This is good. You're becoming a skilled speaker."
            ## phase 2
            if sselecta == 1:
                n "You talk a little bit about how lust can be used to increase drive. A man who loves women will want to look better for them, so he will work hard on himself."
                n "You speak about how the body is a temple, and that by treating it like it, you indirectly become closer to god."
                n "A little loose, but it works."
            elif sselecta == 2:
                n "You talk a little bit about how pride can be used to make life better."
                n "Being proud of ones family will lead to giving them better things, ones house to better living, one's community to better lives for everyone."
            elif sselecta == 3:
                n "You start talking about how greed can indirectly lead to cleverness. A greedy man who patches the holes he might otherwise abuse makes life better for everyone."
                n "You notice a lot of suspicious glances from the audience, and you can't blame them. You're a scholar from a rich city, preaching in a poor town."
            elif sselecta == 4:
                n "You start talking about how envy can lead to better planning, and more drive to work."
                n "One who does not want a better situation by observing others will never grow. You give some advice about where that fine line lays, between constructive a destructive groth."
            elif sselecta == 5:
                n "you start talking about how a side effect of gluttony can be a refined taste, and give some ideas on how to serve ones community with that."
                n "You speak of how a chef is a painter and a food his canvas, and this is the perfect place for the glutton to make things everyone can enjoy."
            elif sselecta == 6:
                n "You start talking about how the wrathful can trade the sword for a pen and create real change in the world."
                n "You speak about Martin Luther, and how his use of the pen brought much needed reforms, and encourage your congregation to become warriors of paper..."
                n "However, it dawns on you that several may not be able to read or write. One problem at a time."
            else:
                n "You start talking about how the slothful are the best people to use to find the simplest way to finish any problem."
                n "You speak of the Carbon Paper, a invention by a english man in the early 1800s that allowed multiple documents to be made on a single typewriter."
                n "Were it not for that shortcut, the paperwork of the clergy would take three times as long. You push for your congregation to look for similar innovations."
            $ sselecth == round(squa * (sselect2 / sselect1))
            if sselecth <= 25:
                n "You doubt it was enough to sway anyone, but at least one person looked impressed."
            elif sselecth <= 50:
                n "Once you stop speaking there are a few looks, and you feel you might have reached a couple of people."
            elif sselecth <= 75:
                n "As soon as you stop, there is some chatter in the crowd. One couple looks almost about to come to blows, but everyone keeps their cool. Sounds like a few people listened."
            elif sselecth <= 100:
                n "There are a lot of people nodding. It seems you've gotten through to quite a few people."
            else:
                n "The people hang on your every word. This is good. You're becoming a skilled speaker."
            n "Finally, you sing some songs, say some prayers, and file everyone out."
            n "You open up the confessional, and the few stragglers that stay go through one at a time, and you absolve them of thier sins."
            $ sselecti = round((sselect1 + sselecth) / 25) - 5
            $ sselectj = gfai
            while sselectj >= 1:
                if renpy.random.randint(1, 500) >= (500 - sselecti):
                    $ mone += 1
                    $ sselectk += 1
                $ sselectj -= 1
            if sselectk >= 1:
                n "You check the donation box and find [sselectk] coins!"
            ## Week Reset.
        "No":
            n "There's something you don't like about today. Maybe it the sky, or the sea. Or something you read."
            n "You lock up and spend the entire day praying. There are a few confused knocks, but you get the feeling the villagers understand what this means."
            ## Week Reset.
    jump advance

label shoppingeach:
    menu:
        "Where do you want to shop?"
        "The Grocier." if mone >= 1:
            scene bg grocier
            n "Eileen looks up from her work, waiting for your order."
            menu:
                "How many groceries do you want?"
                "One meals worth." if mone >= 1:
                    $ mone = mone - 1
                    $ vege = vege + 1
                    n "You pay Eileen and grab your groceries."
                    jump shoppingeach
                "Two meals worth." if mone >= 2:
                    $ mone = mone - 2
                    $ vege = vege + 2
                    n "You pay Eileen and grab your groceries."
                    jump shoppingeach
                "Three meals worth." if mone >= 3:
                    $ mone = mone - 3
                    $ vege = vege + 3
                    n "You pay Eileen and grab your groceries."
                    jump shoppingeach
                "Eileen, a moment. I think your flour is infected with ergot." if storyflags['ego1'] == 1:
                    e "Her face hardens, and she looks you over. \"That's a mighty claim, Reverend. Who's sick?\""
                    n "You tell her of the Whittmores. She walks to the back, and returns with a cloth sack, opening it."
                    n "You smell the distinct, nutty and musty smell of ergot. You can see by her face she does too."
                    n "\"DAMNED! This is just what I need. I... I know who ordered it, and I'll get my boys to collect the infected sacks. Thank you, Reverend.\""
                    $ storyflags['ego1'] = 2
                    jump shoppingeach
                "Return to the market":
                    n "You give Eileen a small wave, and return to the market."
                    jump shoppingeach
        "The Fishmongerer." if mone >= 1:
            scene bg grocier
            n "Patrick sits back in his chair and eyes you."
            menu:
                "How much fish do you want?"
                "One meals worth." if mone >= 1:
                    $ mone = mone - 1
                    $ meat = meat + 1
                    n "You pay Patrick and grab your fish."
                    jump shoppingeach
                "Two meals worth." if mone >= 2:
                    $ mone = mone - 2
                    $ meat = meat + 2
                    n "You pay Patrick and grab your fish."
                    jump shoppingeach
                "Three meals worth." if mone >= 3:
                    $ mone = mone - 3
                    $ meat = meat + 3
                    n "You pay Patrick and grab your fish."
                    jump shoppingeach
                "Return to the market":
                    n "You give Patrick a small wave, and return to the market."
                    jump shoppingeach
        "The Lumberyard." if mone >= 1:
            scene bg grocier
            n "You can't help but stick your hands in your pockets as you enter."
            menu:
                "How much wood do you want?"
                "One stack." if mone >= 1:
                    $ mone = mone - 1
                    $ wood = wood + 1
                    n "You pay the worker and grab your wood."
                    jump shoppingeach
                "Two stack." if mone >= 2:
                    $ mone = mone - 2
                    $ wood = wood + 2
                    n "You pay the worker and grab your wood."
                    jump shoppingeach
                "Three stack." if mone >= 3:
                    $ mone = mone - 3
                    $ wood = wood + 3
                    n "You pay the worker and grab your wood."
                    jump shoppingeach
                "Return to the market":
                    n "You give Patrick a small wave, and return to the market."
                    jump shoppingeach
        "Buy Laudanum from Asmund" if mone >= 1:
            menu:
                "Buy Laudnum" if knows_laud is 1:
                    $ mone = mone - 1
                    $ laud = laud + 1
                    $ mood = mood + 5
                    n "You find Asmund, and buy another bottle of laudanum. In no time, it's gone."
                    jump shoppingeach
                "Buy Lantern" if knows_cave1 is 1 and mone >= 7 and lant <= 0:
                    $ mone = mone -5
                    $ lant = lant + 1
                    n "You approach Asmund and make a request for a lantern. After a few minutes he returns with one."
                    jump shoppingeach
        "Finish shopping for the day":
            n "You collect your purchases and make the way back up to the church."
            jump advance

label library:
    menu:
        "Do you want to..."
        "...read something specific?":
            menu:
                "What do you want to read?"
                "Something from the natural sciences?":
                    menu:
                        "Which book?"
                        "Edible mushrooms of the Eastern Islands" if skill_mushroom_edible >= 1:
                            n "You find a book on edible mushrooms, and take some time to read it. You learn a lot, but you feel like you need to see some in the wild for it to stick."
                            $ skill_mushroom_edible = skill_mushroom_edible + 1
                            jump advance
                        "Poisonous Mushrooms of Canada and the United States" if skill_mushroom_poisonus >= 1:
                            n "You find a book on poisonus mushrooms, and take some time to read it. You learn a lot, but you feel like you need to see some in the wild for it to stick."
                            $ skill_mushroom_poisonus = skill_mushroom_poisonus + 1
                            jump advance
                        "Hallucinogenic Mushrooms of the East Coast" if skill_mushroom_psych >= 1:
                            n "You find a book on hallucinogenic mushrooms, and take some time to read it. You learn a lot, but you feel like you need to see some in the wild for it to stick."
                            $ skill_mushroom_psych = skill_mushroom_psych + 1
                            jump advance
                        "Classical Medicinal Mushrooms" if skill_mushroom_health >= 1:
                            n "You find a book on medicinal mushrooms, and take some time to read it. You learn a lot, but you feel like you need to see some in the wild for it to stick."
                            $ skill_mushroom_health = skill_mushroom_health + 1
                            jump advance
                        "Edible Plants of the Pacific Northwest" if skill_forage_edible >= 1:
                            n "You find a book on edible plants, and take some time to read it. You learn a lot, but you feel like you need to see some in the wild for it to stick."
                            $ skill_forage_edible = skill_forage_edible + 1
                            jump advance
                        "Poisonous Plants of the Pacific Northwest" if skill_forage_poisonus >= 1:
                            n "You find a book on poisonus plants, and take some time to read it. You learn a lot, but you feel like you need to see some in the wild for it to stick."
                            $ skill_forage_poisonus = skill_forage_poisonus + 1
                            jump advance
                        "Tripping through Eastern Canada" if skill_forage_psych >= 1:
                            n "You find a book on psychadellic plants, and take some time to read it. You learn a lot, but you feel like you need to see some in the wild for it to stick."
                            $ skill_forage_psych = skill_forage_psych + 1
                            jump advance
                        "Medicinal Plants of Canada and the United States" if skill_forage_health >= 1:
                            n "You find a book on psychadellic plants, and take some time to read it. You learn a lot, but you feel like you need to see some in the wild for it to stick."
                            $ skill_forage_health = skill_forage_health + 1
                            jump advance
                        "Nah, maybe something else.":
                            jump library
                "Something more historical?":
                    menu:
                        "Which book?"
                        "Runes of the Norse People" if skill_runes >= 1:
                            n "You find a book on norse runes, and take some time to read it. It's interesting reading about the language and it has some neat sections on augery."
                            $ skill_runes = skill_runes + 1
                            jump advance
                        "Rituals of the Maritime Islands" if skill_history >= 1:
                            n "You find a book on maritime island rituals, and take some time to read it. Makes a lot of the stuff you've seen make more sense."
                            if skill_history is 2:
                                n "It seems that a lot of rituals have to do with blood or... bloodlike things? There's a lot of unclear talk about symbolism."
                            elif skill_history >= 3:
                                n "This section deals a lot more with historical ritals, and speaks about... a old local ritual! It seems under certain situations that a group bloodletting would work instead of a full on sacrifice."
                                n "The ritual is pretty clearly defined - you have enough information you could probably redo it."
                                if tantrum_alice is 1:
                                    n "You might want to approach the town historian with this info. He might know who to talk to next."
                            $ skill_history = skill_history + 1
                            jump advance
                        "Nah, maybe something else.":
                            jump library
                "Something from the Physical Sciences?":
                    menu:
                        "Which book?"
                        "Chemistry and You" if skill_chemistry >= 1:
                            n "You find a book on chemistry and take some time to read it. It's pretty dense, but might have some useful information."
                            $ skill_chemistry = skill_chemistry + 1
                            jump advance
                        "Nah, maybe something else.":
                            jump library
        "...pick something new at random?":
            $ select = renpy.random.randint(1, 11)
            n "you walk up to the bookshelf, and select a book at random."
            if select is 1:
                if skill_mushroom_poisonus is 0:
                    n "You find a book on poisonus mushrooms, and take some time to read it. You learn a lot, but you feel like you need to see some in the wild for it to stick."
                    $ skill_mushroom_poisonus = skill_mushroom_poisonus + 1
                else:
                    $ select = select + 1
            if select is 2:
                if skill_mushroom_health is 0:
                    n "You find a book on medicinal mushrooms, and take some time to read it. You learn a lot, but you feel like you need to see some in the wild for it to stick."
                    $ skill_mushroom_health = skill_mushroom_health + 1
                else:
                    $ select = select + 1
            if select is 3:
                if skill_mushroom_psych is 0:
                    n "You find a book on hallucinogenic mushrooms, and take some time to read it. You learn a lot, but you feel like you need to see some in the wild for it to stick."
                    $ skill_mushroom_psych = skill_mushroom_psych + 1
                else:
                    $ select = select + 1
            if select is 4:
                if skill_forage_edible is 0:
                    n "You find a book on edible plants, and take some time to read it. You learn a lot, but you feel like you need to see some in the wild for it to stick."
                    $ skill_forage_edible = skill_forage_edible + 1
                else:
                    $ select = select + 1
            if select is 5:
                if skill_forage_health is 0:
                    n "You find a book on wild plants, and flip to a section on medicinal plants. You learn a lot, but you feel like you need to see some in the wild for it to stick."
                    $ skill_forage_health = skill_forage_health + 1
                else:
                    $ select = select + 1
            if select is 6:
                if skill_forage_poisonus is 0:
                    n "You find a book on wild plants, and flip to a section on poisonus plants. You learn a lot, but you feel like you need to see some in the wild for it to stick."
                    $ skill_forage_poisonus = skill_forage_poisonus + 1
                else:
                    $ select = select + 1
            if select is 7:
                if skill_mushroom_edible is 0:
                    n "You find a book on edible mushrooms, and take some time to read it. You learn a lot, but you feel like you need to see some in the wild for it to stick."
                    $ skill_mushroom_edible = skill_mushroom_edible + 1
                else:
                    $ select = select + 1
            if select is 8:
                if skill_runes is 0:
                    n "You find a book on norse runes, and take some time to read it. It's interesting reading about the language and it has some neat sections on augery."
                    $ skill_runes = skill_runes + 1
                else:
                    $ select = select + 1
            if select is 9:
                if skill_history is 0:
                    n "You find a book on norse runes, and take some time to read it. It's interesting reading about the language and it has some neat sections on augery."
                    $ skill_history = skill_history + 1
                else:
                    $ select = select + 1
            if select is 10:
                if skill_chemistry is 0:
                    n "You find a book on chemistry and take some time to read it. It's pretty dense, but might have some useful information."
                    $ skill_chemistry = skill_chemistry + 1
                else:
                    $ select = select + 1
            if select is 11:
                n "You find a book on dirty limerics. You don't like it as much as you hoped."
    jump advance

label laundry:
    scene bg altar
    $ laun = laun - 1
    $ mood = mood + 1
    n "You finally take the time to do some of the chores that have been piling up. You wash your clothing in a basin, and detail the church and your residence. It takes hours, and you feel better."
    jump advance

label mill:
    scene bg forest
    $ holding = renpy.random.randint( 2, 5)
    $ wood = wood + holding
    $ raw_wood = raw_wood - 2
    n "You set up the mill. You used something similar in your time in seminary overseas, and you spend the next few hours producting [holding] building supplies."
    jump advance

label chopwood:
    scene bg forest
    $ holding = renpy.random.randint( 2, 5)
    $ raw_wood = raw_wood + holding
    n "You grab the lumber axe and some chains and climb down to the nearby forest. It takes some work, but you harvest [holding] trees."
    jump advance

label cproperty:
    scene bg altar
    menu:
        "You work on..."
        "...the church." if mbui >= 1:
            n "You take some lumber and replace the most egregious rotten and broken boards."
            $ mbui = mbui - renpy.random.randint( 2, 5)
            $ wood = wood - 1
            if mbui < 0:
                $ mbui = 0
            jump advance
        "...the graveyard." if grav >= 1:
            n "You take some lumber and clean up, reinforce, and replace the most broken items."
            $ grav = grav - renpy.random.randint( 2, 5)
            $ wood = wood - 1
            if grav < 0:
                $ grav = 0
            jump advance
        "...the fence." if fenc >= 1:
            n "You take some lumber and rebuild the worst sections of the fences."
            $ grav = grav - renpy.random.randint( 2, 5)
            $ wood = wood - 1
            if grav < 0:
                $ grav = 0
            jump advance
        "...something else.":
            jump no_advance

label clean:
    n "You sweep out the main room, clean the candle wax and replace burnt out candles. It takes a few minutes, and makes you feel a fair bit better."
    $ clea = clea - 1
    $ mood = mood + 1
    jump advance

label sermon:
    menu:
        "You write about..."
        "The sin of Pride":
            $ select = renpy.random.randint(1, 20)
            if select is 1:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b}James 4:6{/b}{i}\"But he gives us more grace. That is why Scripture says: 'God opposes the proud but shows favor to the humble.\"{/i}"
                n "You write a story about a woodcutter who injurs himself at work, and is too proud to seek treatment, and it gets infected and he has a slow, painful death."
                n "It's very gruesome all in all."
                n "You hope the message lands."
            if select is 2:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b}1 Peter 5:5-6{/b}{i}\"In the same way, you who are younger, submit yourselves to your elders. All of you, clothe yourselves with humility toward one another, because, 'God opposes the proud but shows favor to the humble.'{/i}"
                n "{i}Humble yourselves, therefore, under God’s mighty hand, that he may lift you up in due time\"{/i}"
                n "You write a story about children and a dangerous river. Every day the children's grandfather warns them how dangerous it is, and every day they sneak away, until one slips and drowns."
                n "It's all very morbid."
                n "You hope the message lands."
            if select is 3:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Proverbs 29:23{/b}{i}\"Pride brings a person low, but the lowly in spirit gain honor.\"{/i}"
                n "You weave a yarn about two bakers, one who spends his days decrying his competitors and has to live through feast and famine, and another who simply lets the quality speak for itself."
                n "By the end of the story, the proud baker ends up on the streets, while the humble one is still open and has faithful customers."
                n "Even though you're noticing a clear capitalist bent to your sermon, you hope the message lands."
            if select is 4:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Proverbs 11:2{/b}{i}\"When pride comes, then comes disgrace, but with humility comes wisdom\"{/i}"
                n "You weave a tale about a politician whos pride becomes so great they stop listening to their advisors, and eventually lose everything in a foolhardy personal quest."
                n "It's very poigniant."
            if select is 5:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Luke 14:11{/b}{i}\"For all those who exalt themselves will be humbled, and those who humble themselves will be exalted.\"{/i}"
                n "You write a story about a big town mayor who thinks he's better than everyone else who gets stuck alone in his burning mansion when no one will risk themselves to save him."
                n "It's very dark."
            if select is 6:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Proverbs 16:18{/b}{i}\"Pride goes before destruction, a haughty spirit before a fall.\"{/i}"
                n "You weave a tale of a fisherman so proud of his nets and the bulk of his catches that he refuses to listen to the weavers on shore when they try to warn him of fraying."
                n "Of course, the net shreds on his next haul and he looses the entire catch. Very tragic."
            if select is 7:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Proverbs 8:13{/b}{i}\"To fear the Lord is to hate evil; I hate pride and arrogance, evil behavior and perverse speech.\"{/i}"
                n "You write a story about a king who is so proud he ignores all wisdom of his advisors, while his humble advisors recieved gods gifts."
                n "Too much on the nose? Probably."
            if select is 8:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Isaiah 13:11{/b}{i}\"I will put an end to the arrogance of the haughty and will humble the pride of the ruthless.\"{/i}"
                n "A STORY GOES HERE"
            if select is 9:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Proverbs 18:12{/b}{i}\"Before a downfall the heart is haughty, but humility comes before honor.\"{/i}"
                n "A STORY GOES HERE"
            if select is 10:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Proverbs 29:23{/b}{i}\"Pride brings a person low, but the lowly in spirit gain honor.\"{/i}"
                n "A STORY GOES HERE"
            if select is 11:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Obadiah 1:3{/b}{i}\"The pride of your heart has deceived you, you who live in the clefts of the rocks and make your home on the heights...\"{/i}"
                n "A STORY GOES HERE"
            if select is 12:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Psalm 10:4{/b}{i}\"In his pride the wicked man does not seek him; in all his thoughts there is no room for God.\"{/i}"
                n "A STORY GOES HERE"
            if select is 13:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} James 4:6{/b}{i}\"God opposes the proud but shows favor to the humble.\"{/i}"
                n "A STORY GOES HERE"
            if select is 14:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} John 2:16{/b}{i}\"For everything in the world—the lust of the flesh, the lust of the eyes, and the pride of life—comes not from the Father but from the world.\"{/i}"
                n "A STORY GOES HERE"
            if select is 15:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Romans 12:3{/b}{i}\"Do not think of yourself more highly than you ought, but rather think of yourself with sober judgment...\"{/i}"
                n "A STORY GOES HERE"
            if select is 16:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Galatians 6:3{/b}{i}\"If anyone thinks they are something when they are not, they deceive themselves.\"{/i}"
                n "A STORY GOES HERE"
            if select is 17:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Philippians 2:3{/b}{i}\"Do nothing out of selfish ambition or vain conceit. Rather, in humility value others above yourselves.\"{/i}"
                n "A STORY GOES HERE"
            if select is 18:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Isaiah 2:11{/b}{i}\"The eyes of the arrogant will be humbled and human pride brought low; the Lord alone will be exalted in that day.\"{/i}"
                n "A STORY GOES HERE"
            if select is 19:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Jeremiah 9:23{/b}{i}\"This is what the Lord says: 'Let not the wise boast of their wisdom or the strong boast of their strength or the rich boast of their riches...\"{/i}"
                n "A STORY GOES HERE"
            if select is 20:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b}Proverbs 16:18-19:{/b}{i}\"Pride goes before destruction, a haughty spirit before a fall. Better to be lowly in spirit along with the oppressed than to share plunder with the proud.\"{/i}"
                n "You write a hypothetical story about a proud farmer who with all his bluster causes the others in his communities crops to fail."
                n "You hope the message lands."
            $ squa = squa + renpy.random.randint( sin_pride + 1, (sin_pride + 5) * sin_pride)
            $ ssin_pride += 1

        "The sin of Greed":
            $ select = renpy.random.randint(1, 20)
            if select is 1:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Luke 12:15{/b}{i}\"Then he said to them, 'Watch out! Be on your guard against all kinds of greed; life does not consist in an abundance of possessions.'\"{/i}"
                n "TODO: Expand Jesus warns against greed and reminds us that true life is not found in material wealth."
            if select is 2:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b}1 Timothy 6:9-10{/b}{i}\"Those who want to get rich fall into temptation and a trap and into many foolish and harmful desires that plunge people into ruin and destruction. For the love of money is a root of all kinds of evil. Some people, eager for money, have wandered from the faith and pierced themselves with many griefs\"{/i}"
                n "TODO: Expand This passage highlights the dangers of greed and the love of money, which can lead people away from faith."
            if select is 3:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Hebrews 13:5{/b}{i}\"Keep your lives free from the love of money and be content with what you have, because God has said, 'Never will I leave you; never will I forsake you.'\"{/i}"
                n "TODO: Expand This verse encourages contentment and trust in God's provision rather than greed."
            if select is 4:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b}Ecclesiastes 5:10{/b}{i}\"Whoever loves money never has enough; whoever loves wealth is never satisfied with their income. This too is meaningless.\"{/i}"
                n "TODO: Expand This highlights the emptiness of pursuing wealth and the insatiable nature of greed."
            if select is 5:
                $ "You consider everything you've seen and heard this week."
                n "You are drawn to {b}Proverbs 15:27{/b}{i}\"The greedy bring ruin to their households, but the one who hates bribes will live.\"{/i}"
                n "TODO: Expand This verse shows how greed can have destructive consequences, especially within families."
            if select is 6:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Exodus 20:17{/b}{i}\"You shall not covet your neighbor’s house. You shall not covet your neighbor’s wife... or anything that belongs to your neighbor.\"{/i}"
                n "A STORY GOES HERE"
            if select is 7:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Proverbs 15:27{/b}{i}\"The greedy bring ruin to their households, but the one who hates bribes will live.\"{/i}"
                n "A STORY GOES HERE"
            if select is 8:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Proverbs 28:25{/b}{i}\"The greedy stir up conflict, but those who trust in the Lord will prosper.\"{/i}"
                n "A STORY GOES HERE"
            if select is 9:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Isaiah 56:11{/b}{i}\"They are dogs with mighty appetites; they never have enough. They are shepherds who lack understanding...\"{/i}"
                n "A STORY GOES HERE"
            if select is 10:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Micah 2:2{/b}{i}\"They covet fields and seize them, and houses, and take them. They defraud people of their homes...\"{/i}"
                n "A STORY GOES HERE"
            if select is 11:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Jeremiah 6:13{/b}{i}\"From the least to the greatest, all are greedy for gain; prophets and priests alike, all practice deceit.\"{/i}"
                n "A STORY GOES HERE"
            if select is 12:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Habakkuk 2:9{/b}{i}\"Woe to him who builds his house by unjust gain, setting his nest on high to escape the clutches of ruin!\"{/i}"
                n "A STORY GOES HERE"
            if select is 13:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Proverbs 1:19{/b}{i}\"Such are the paths of all who go after ill-gotten gain; it takes away the life of those who get it.\"{/i}"
                n "A STORY GOES HERE"
            if select is 14:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Job 20:20{/b}{i}\"Surely he will have no respite from his craving; he cannot save himself by his treasure.\"{/i}"
                n "A STORY GOES HERE"
            if select is 15:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Luke 12:15{/b}{i}\"Watch out! Be on your guard against all kinds of greed; life does not consist in an abundance of possessions.\"{/i}"
                n "A STORY GOES HERE"
            if select is 16:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} 1 Timothy 6:10{/b}{i}\"For the love of money is a root of all kinds of evil...\"{/i}"
                n "A STORY GOES HERE"
            if select is 17:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Colossians 3:5{/b}{i}\"Put to death... greed, which is idolatry.\"{/i}"
                n "A STORY GOES HERE"
            if select is 18:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Ephesians 5:5{/b}{i}\"For of this you can be sure: No immoral, impure or greedy person—such a person is an idolater—has any inheritance in the kingdom of Christ and of God.\"{/i}"
                n "A STORY GOES HERE"
            if select is 19:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Hebrews 13:5{/b}{i}\"Keep your lives free from the love of money and be content with what you have...\"{/i}"
                n "A STORY GOES HERE"
            if select is 20:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b}1 Timothy 6:9-10:{/b}"
                n "{i}\"Those who want to get rich fall into temptation and a trap and into many foolish and harmful desires that plunge people into ruin and destruction. For the love of money is a root of all kinds of evil. Some people, eager for money, have wandered from the faith and pierced themselves with many griefs.\"{/i}"
                n "You spin about a hour of material off of this, then strip it down to only the best stuff. Hopefully, this will make the lessons stick."
            $ squa = squa + renpy.random.randint( sin_greed + 1, (sin_greed + 5) * sin_greed)
            $ ssin_greed += 1

        "The sin of Lust":
            $ select = renpy.random.randint(1, 20)
            if select is 1:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Exodus 20:17{/b}{i}\"You shall not covet your neighbor’s wife...\"{/i}"
                n "A STORY GOES HERE"
            if select is 2:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Job 31:1{/b}{i}\"I made a covenant with my eyes not to look lustfully at a young woman.\"{/i}"
                n "A STORY GOES HERE"
            if select is 3:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Proverbs 6:25{/b}{i}\"Do not lust in your heart after her beauty or let her captivate you with her eyes.\"{/i}"
                n "A STORY GOES HERE"
            if select is 4:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Proverbs 7:21–23{/b}{i}\"With persuasive words she led him astray... little knowing it will cost him his life.\"{/i}"
                n "A STORY GOES HERE"
            if select is 5:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Proverbs 11:6 {/b}{i}\"The righteousness of the upright delivers them, but the unfaithful are trapped by evil desires.\"{/i}"
                n "A STORY GOES HERE"
            if select is 6:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Ezekiel 23:20{/b}{i}\"There she lusted after her lovers, whose genitals were like those of donkeys and whose emission was like that of horses.\"{/i}"
                n "A STORY GOES HERE"
            if select is 7:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} 2 Samuel 11:2–4 {/b}{i}\"David saw a woman bathing... and David sent messengers to get her.\"{/i}"
                n "A STORY GOES HERE"
            if select is 8:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Genesis 39:7–9 {/b}{i}\"How then could I do such a wicked thing and sin against God?\"{/i}"
                n "A STORY GOES HERE"
            if select is 9:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Psalm 119:37 {/b}{i}\"Turn my eyes away from worthless things; preserve my life according to your word.\"{/i}"
                n "A STORY GOES HERE"
            if select is 10:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Hosea 4:10 {/b}{i}\"They will eat but not have enough; they will engage in prostitution but not flourish, because they have deserted the Lord to give themselves to prostitution.\"{/i}"
                n "A STORY GOES HERE"
            if select is 11:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Matthew 5:28 {/b}{i}\"But I tell you that anyone who looks at a woman lustfully has already committed adultery with her in his heart.\"{/i}"
                n "A STORY GOES HERE"
            if select is 12:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} 1 Thessalonians 4:3–5 {/b}{i}\"It is God’s will that you should be sanctified: that you should avoid sexual immorality...\"{/i}"
                n "A STORY GOES HERE"
            if select is 13:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} 2 Timothy 2:22 {/b}{i}\"Flee the evil desires of youth and pursue righteousness...\"{/i}"
                n "A STORY GOES HERE"
            if select is 14:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Romans 13:13–14 {/b}{i}\"...not in sexual immorality and debauchery... Rather, clothe yourselves with the Lord Jesus Christ, and do not think about how to gratify the desires of the flesh.\"{/i}"
                n "A STORY GOES HERE"
            if select is 15:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} 1 John 2:16 {/b}{i}\"For everything in the world—the lust of the flesh, the lust of the eyes...—comes not from the Father but from the world.\"{/i}"
                n "A STORY GOES HERE"
            if select is 16:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Galatians 5:16 {/b}{i}\"So I say, walk by the Spirit, and you will not gratify the desires of the flesh.\"{/i}"
                n "A STORY GOES HERE"
            if select is 17:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Ephesians 5:3 {/b}{i}\"But among you there must not be even a hint of sexual immorality, or of any kind of impurity...\"{/i}"
                n "A STORY GOES HERE"
            if select is 18:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} Colossians 3:5{/b}{i}\"Put to death, therefore, whatever belongs to your earthly nature: sexual immorality, impurity, lust...\"{/i}"
                n "A STORY GOES HERE"
            if select is 19:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b} 1 Corinthians 6:18–20{/b}{i}\"Flee from sexual immorality... your bodies are temples of the Holy Spirit... Therefore honor God with your bodies.\"{/i}"
                n "A STORY GOES HERE"
            if select is 20:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b}1 John 2:16:{/b}"
                n "{i}\"For everything in the world—the lust of the flesh, the lust of the eyes, and the pride of life—comes not from the Father but from the world.\"{/i}"
                n "You weave a driving narriative to pound home the sins of lechery and lust as hard as you can..."
                n "...using THICK, STRONG strokes with your HARD ink pen..."
                n "...to the SUPPLE paper."
                n "..."
                n "Oh dear."
                n "You hope you get some use out of this. You should probably go for a walk."
            $ squa = squa + renpy.random.randint( sin_lust + 1, (sin_lust + 5) * sin_lust)
            $ ssin_lust += 1

        "The sin of Envy":
            $ select = renpy.random.randint(1, 6)
            if select is 1:
                $ select += 1
            if select is 2:
                $ select += 1
            if select is 3:
                $ select += 1
            if select is 4:
                $ select += 1
            if select is 5:
                $ select += 1
            if select is 6:
                $ select += 1
            if select is 7:
                $ select += 1
            if select is 8:
                $ select += 1
            if select is 9:
                $ select += 1
            if select is 10:
                $ select += 1
            if select is 11:
                $ select += 1
            if select is 12:
                $ select += 1
            if select is 13:
                $ select += 1
            if select is 14:
                $ select += 1
            if select is 15:
                $ select += 1
            if select is 16:
                $ select += 1
            if select is 17:
                $ select += 1
            if select is 18:
                $ select += 1
            if select is 19:
                $ select += 1
            if select is 20:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b}Proverbs 14:30:{/b}"
                n "{i}\"A heart at peace gives life to the body, but envy rots the bones.\"{/i}"
                n "You start the sermon, but your mind constantly drifts to those of your mentor, and soon, you scrap it out of disgust."
                n "You start the sermon again, but soon you are comparing yourself to other students. You are sure you will never rise to their hights. You scrap it."
                n "Finally, you step out onto the cliffs. You see the calm ocean, feel the light breeze, and it makes it easier. You finish."
                n "The time is gone, but the lesson is not."
            $ squa = squa + renpy.random.randint( sin_envy + 1, (sin_envy + 5) * sin_envy)
            $ ssin_envy += 1

        "The sin of Gluttony":
            $ select = renpy.random.randint(1, 6)
            if select is 1:
                $ select += 1
            if select is 2:
                $ select += 1
            if select is 3:
                $ select += 1
            if select is 4:
                $ select += 1
            if select is 5:
                $ select += 1
            if select is 6:
                $ select += 1
            if select is 7:
                $ select += 1
            if select is 8:
                $ select += 1
            if select is 9:
                $ select += 1
            if select is 10:
                $ select += 1
            if select is 11:
                $ select += 1
            if select is 12:
                $ select += 1
            if select is 13:
                $ select += 1
            if select is 14:
                $ select += 1
            if select is 15:
                $ select += 1
            if select is 16:
                $ select += 1
            if select is 17:
                $ select += 1
            if select is 18:
                $ select += 1
            if select is 19:
                $ select += 1
            if select is 20:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b}Philippians 3:19{/b}"
                n "{i}\"Their destiny is destruction, their god is their stomach, and their glory is in their shame. Their mind is set on earthly things.\"{/i}"
                n "You work on this task, but quickly it spirals into an almost neurotic structured plan for how to keep a household. You start again..."
                n "You work on this task again, but quickly it spirals into an almost neurotic structured plan for how to keep a household. You start again..."
                n "You work on this task again, again, but quickly it spirals into an almost neurotic structured plan for how to keep a household. You start again..."
                n "Several hours pass. You salvage what you can."
            $ squa = squa + renpy.random.randint( sin_gluttony + 1, ((sin_gluttony + 5) * sin_gluttony) + 1)
            $ ssin_gluttony += 1

        "The sin of Wrath":
            $ select = renpy.random.randint(1, 6)
            if select is 1:
                $ select += 1
            if select is 2:
                $ select += 1
            if select is 3:
                $ select += 1
            if select is 4:
                $ select += 1
            if select is 5:
                $ select += 1
            if select is 6:
                $ select += 1
            if select is 7:
                $ select += 1
            if select is 8:
                $ select += 1
            if select is 9:
                $ select += 1
            if select is 10:
                $ select += 1
            if select is 11:
                $ select += 1
            if select is 12:
                $ select += 1
            if select is 13:
                $ select += 1
            if select is 14:
                $ select += 1
            if select is 15:
                $ select += 1
            if select is 16:
                $ select += 1
            if select is 17:
                $ select += 1
            if select is 18:
                $ select += 1
            if select is 19:
                $ select += 1
            if select is 20:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b}James 1:19-20:{/b}"
                n "{i}\"My dear brothers and sisters, take note of this: Everyone should be quick to listen, slow to speak and slow to become angry, because human anger does not produce the righteousness that God desires.\"{/i}"
                n "You write a long meandering prose about how rage is the center of all bad things, and then you edit it."
                n "You write more prose about how rage pulls you away from the path that god has set out for you, but then you remember where you are and edit it."
                n "You write more about how patience is a virtue that combats wrath. Aww yeah. That's the good stuff."
                n "You edit out all the garbage and get some good stuff out of it."
            $ squa = squa + renpy.random.randint( sin_wrath + 1, (sin_wrath + 5) * sin_wrath)
            $ ssin_wrath += 1

        "The sin of Sloth":
            $ select = renpy.random.randint(1, 6)
            if select is 1:
                $ select += 1
            if select is 2:
                $ select += 1
            if select is 3:
                $ select += 1
            if select is 4:
                $ select += 1
            if select is 5:
                $ select += 1
            if select is 6:
                $ select += 1
            if select is 7:
                $ select += 1
            if select is 8:
                $ select += 1
            if select is 9:
                $ select += 1
            if select is 10:
                $ select += 1
            if select is 11:
                $ select += 1
            if select is 12:
                $ select += 1
            if select is 13:
                $ select += 1
            if select is 14:
                $ select += 1
            if select is 15:
                $ select += 1
            if select is 16:
                $ select += 1
            if select is 17:
                $ select += 1
            if select is 18:
                $ select += 1
            if select is 19:
                $ select += 1
            if select is 20:
                n "You consider everything you've seen and heard this week."
                n "You are drawn to {b}Proverbs 13:4:{/b}"
                n "{i}\"A sluggard’s appetite is never filled, but the desires of the diligent are fully satisfied.\"{/i}"
                n "You start on a sieze the day style sermon, but get distracted when the man you doodle in the margins discovers fire."
                n "As you delve deeper into the topic, the page becomes more filled, and the stick men empire enters the bronze age."
                n "You polish the finishing touches, but are shattered when the war eliminates both side and leaves your page a diorama of destruction."
                n "You salvage what you can."
            $ squa = squa + renpy.random.randint( sin_sloth + 1, (sin_sloth + 5) * sin_sloth)
            $ ssin_sloth += 1
    $ spar = spar + 1
    jump advance

label woods:
    scene bg path
    $ select = renpy.random.randint(1, 6)
    n "You decide to take a walk through the forest to clear your mind and center yourself."
    n "You cross the graveyard and follow a little well worn trail that follows the cliffside and goes down into an evergreen forest below."
    n "The cold, crisp air revitalizes you, and the farther you walk, the better you feel."
    $ mood = mood + 1
    if mood <= 25:
        $ mood = mood + 2
    if select is 1:
        call VMoo_A_forest_ediblemushroom from _call_VMoo_A_forest_ediblemushroom
    if select is 2:
        call GW_A_forest_contemplate1 from _call_GW_A_forest_contemplate1
    if select is 3:
        call P_A_forest_contemplate2 from _call_P_A_forest_contemplate2
    if select is 4:
        call MH_A_forest_healthmushroom from _call_MH_A_forest_healthmushroom
    if select is 5:
        call Mo_A_forest_money from _call_Mo_A_forest_money
    if select is 6:
        call loc_cave1 from _call_loc_cave1
    if select is 7:
        pass
    if select is 8:
        pass
    if select is 9:
        pass
    if select is 10:
        pass
    if select is 11:
        pass
    if select is 12:
        pass
    if select is 13:
        pass
    if select is 14:
        pass
    if select is 15:
        pass
    if select is 16:
        pass
    if select is 17:
        pass
    if select is 18:
        pass
    if select is 19:
        pass
    if select is 20:
        pass
    if select is 21:
        pass
    if select is 22:
        pass
    if select is 23:
        pass
    if select is 24:
        pass
    if select is 25:
        pass
    if select is 26:
        pass
    if select is 27:
        pass
    if select is 28:
        pass
    if select is 29:
        pass
    if select is 30:
        pass
    jump advance
        
label shopping:
    if intro_gro:
        scene bg grocier
        gro "grocier"
        $ select = renpy.random.randint(1, 5)
        if select is 1:
            gro "As you enter the store, Eileen jumps a bit. She stares at you with wild eyes for a second, then calms herself by patting down her apron. \"Reverend… I forgot it was Monday. I apologize… Our harvest has not been good this week from the sea. Afflicted with some kind of blight it is. I have your food here - blight free, as it is, but the town is on edge. Please, allay our fears.\""
            gro "You thank her and collect your food, leaving the 4 pounds on the counter. You should probably do a sermon against greed."
            $ sin_greed = sin_greed + 1
        if select is 2:
            gro "As you enter the grocer, you hear a yelp and the sound of something falling. Eileen stands, covered head to toe in flour. "
            gro "\"Reverend!\" She yells, before calming herself. \"Of course. My apologies. Monday snuck up on me. Your food is on the counter there. Please kindly pay for it and be on your way, while I clean up this mess you MADE me make.\""
            gro "You're not quite sure why this is your fault, but you pay the four pounds and leave with your spoils. You consider a sermon on pride."
            $ sin_pride = sin_pride + 1
        if select is 3:
            gro "You knock on the door to the grocer before opening it, but it seems to have done nothing to ease Eileen's nerves. Her eyes are red, as if she has been crying recently. "
            gro "She sees you and goes off - \"What is the point! We live hard lives sir - what is the point of you and your god! He takes who he wants and we have no say. Pay, take your food, and go.\""
            gro "You do. You consider a sermon on wrath."
            $ sin_wrath = sin_wrath + 1
        if select is 4:
            gro "The door is open to the grocers today, and you enter without any resistance. Eileen seems to be in a good mood for a change, and she waves as you enter. \"Reverend! We are blessed by abundance! Praise the Lord and Praise the Deep!. Here - your food.\" You pay for your food and decide not to press the sacrilege, and discover additional food."
            $ vege = vege + 2
        if select is 5:
            gro "As you enter you have to squeeze past several workmen hauling crates into the grocers, Eileen spots you and waves you over. \"Not a good day today! Here, quickly - your food.\" You drop the coins in her hand. \"Time is money and money is money, right? Ha ha.\" You consider a sermon on greed."
            $ sin_greed = sin_greed + 1
        $ vege = vege + 7
        $ mone = mone - 4
    else:
        scene bg grocier
        gro "Your first stop of the day is the Grocer. Like everyone in this town, the proprietor looks haggard and tired. \"Ah, Reverend. Good day. I am Eileen, and this is my store. I've put aside your order, as requested by Reverend Evohart. If there is something else I can get you, please let me know.\"."
        gro "You collect your food, then leave for your next appointment."
        $ intro_gro = True
        $ vege = vege + 7
    if intro_fsh:
        scene bg fishmogerer
        fsh "As you enter the fishmonger, you are assaulted with the overwhelming stench of fish."
        fsh "Patric looks you up and down, before taking the previous cloth bag from your hand and replacing it with another. \"Fish.\" He says. You place the coins on the counter, he nods, and says \"Goodbye\"."
        $ meat = meat + 7
        $ mone = mone - 4
    else:
        scene bg fishmogerer
        fsh "As you enter the fishmonger, you are assaulted with the overwhelming stench of fish."
        fsh "A small, elderly man behind the counter looks you up and down, before pulling a canvas sack out of a nearby barrel and holding it out to you. \"Fish.\" He says, and as you take it. He nods, and says \"Goodbye\"."
        $ meat = meat + 7
        $ intro_fsh = True
    if intro_lum:
        scene bg lumberyard
        lum "Your final stop is the lumberyard. The worker recognises you immediatly, and waves 2 other workers down holding up 2 fingers. They leave, and he approaches. \"Good day Reverend. That will be two pounds.\" You hand it over, and he nods. \"Goods will be delivered promptly. Good day, Reverend.\""
        $ wood = wood + 2
        $ mone = mone - 2
    else:
        scene bg lumberyard
        n "The lumberyard is rather large for a small, island fishing village, taking up almost a full block on the outskirts of the town."
        n "The large warehouse is full of  beams, and lengths of wood of almost every kind you can imagine. A desk sits just inside the door, and a man is seated behind it."
        lum "\"So, you be the new Reverend? Yes, yes, we will have your wood up to the church this afternoon. Please, come back if you have any other needs.\" You depart."
        $ wood = wood + 4
        $ intro_lum = True
    jump events

label events:
    $ select = renpy.random.randint(1, 21)
    if select is 1:
        call P_A_town_walk1 from _call_P_A_town_walk1
    if select is 2:
        call GMoo_A_town_walk2 from _call_GMoo_A_town_walk2
    if select is 3:
        call EMoo_A_town_walk3 from _call_EMoo_A_town_walk3
    if select is 4:
        call GlMoo_A_town_walk4 from _call_GlMoo_A_town_walk4
    if select is 5:
        call LMoo_A_town_walk5 from _call_LMoo_A_town_walk5
    if select is 6:
        call loc_laud from _call_loc_laud
    if select is 7:
        call loc_museum from _call_loc_museum
    if select is 8:
        call P_A_town_walk6 from _call_P_A_town_walk6
    if select is 9:
        call S_A_town_walk7 from _call_S_A_town_walk7
    if select is 10:
        call WMoo_A_town_walk8 from _call_WMoo_A_town_walk8
    if select is 11:
        call Moo_A_town_walk9 from _call_Moo_A_town_walk9
    if select is 12:
        call A_cliff1 from _call_A_cliff1
    if select is 13:
        call Moo_A_town_walk10 from _call_Moo_A_town_walk10
    if select is 14:
        call E_A_town_walk11 from _call_E_A_town_walk11
    if select is 15:
        call loc_whittmore from _call_loc_whittmore
    if select is 16:
        call SW_A_town_walk12 from _call_SW_A_town_walk12
    if select is 17:
        call LE_A_town_walk13 from _call_LE_A_town_walk13
    if select is 18:
        call PE_A_town_walk14 from _call_PE_A_town_walk14
    if select is 19:
        call LP_A_town_walk15 from _call_LP_A_town_walk15
    if select is 20:
        call LG_A_town_walk16 from _call_LG_A_town_walk16
    if select is 21:
        call LGl_A_town_walk17 from _call_LGl_A_town_walk17
    if select is 22:
        call LS_A_town_walk18 from _call_LS_A_town_walk18
    if select is 23:
        call PG_A_town_walk19 from _call_PG_A_town_walk19
    if select is 24:
        call PGl_A_town_walk20 from _call_PGl_A_town_walk20
    if select is 25:
        call PW_A_town_walk21 from _call_PW_A_town_walk21
    if select is 26:
        call PW_A_town_walk22 from _call_PW_A_town_walk22
    if select is 27:
        call EWV_A_town_walk23 from _call_EWV_A_town_walk23
    if select is 28:
        call Moo_A_town_walk24 from _call_Moo_A_town_walk24
    if select is 29:
        call E_A_town_walk25 from _call_E_A_town_walk25
    if select is 30:
        call Moo_A_town_walk26 from _call_Moo_A_town_walk26
    if select is 31:
        call GE_A_town_walk27 from _call_GE_A_town_walk27
    if select is 32:
        call Moo_A_town_walk28 from _call_Moo_A_town_walk28
    if select is 33:
        call PW_A_town_walk29 from _call_PW_A_town_walk29
    if select is 34:
        call PS_A_town_walk30 from _call_PS_A_town_walk30
    if select is 35:
        call WE_A_town_walk31 from _call_WE_A_town_walk31
    if select is 36:
        call PL_A_town_walk32 from _call_PL_A_town_walk32
    if select is 37:
        call GGl_A_town_walk33 from _call_GGl_A_town_walk33
    if select is 38:
        call WL_A_town_walk34 from _call_WL_A_town_walk34
    if select is 39:
        pass
    if select is 40:
        pass
    if select is 41:
        pass
    if select is 42:
        pass
    if select is 43:
        pass
    if select is 44:
        pass
    if select is 45:
        pass
    if select is 46:
        pass
    if select is 47:
        pass
    if select is 48:
        pass
    if select is 49:
        pass
    if select is 50:
        pass
    if select is 51:
        pass
    if select is 52:
        pass
    if select is 53:
        pass
    if select is 54:
        pass
    if select is 55:
        pass
    if select is 56:
        pass
    if select is 57:
        pass
    if select is 58:
        pass
    if select is 59:
        pass
    if select is 60:
        pass
    if weekday is 0:
        $ segment = segment + 1
    jump advance

label feedthepoor:
    n "Service is one of the tennants of faith, and in a place so many go hungry, how better to do that then by feeding them?"
    n "In a large stock pot you make a hearty chowder of fish and vegetables. There are several stacks of bowls and cutlery in the rectory, and a wooden folding table and cart in the shed."
    n "You load the table and bowls into the cart, placing on top the pot covered in blankets and towels. It should keep it nice and warm."
    n "The journey into town is thankfully very easy - the faithful keep the path clear and of even keel. In no time, you have set up your station in one of the few clear areas of the stacks."
    n "All kinds come out to recieve a bowl. Well over a hundred people. A local fishwife helps keep the bowls washed for new patrons, and you spend two hours dishing out meals."
    n "You see what the previous reverend was talking about. The people here have bulging eyes, cracked sallow skin. They smell of sadness and illness, but they lighten up at food."
    n "All too soon the pot is empty, and you have to turn a few desperate souls away. You can be assured they will be amoungst the first next time."
    #EVENT SELECTOR HERE
    n "You notice Asmund approaching you from the town as you load. He slaps you on the back and then helps you load."
    asm "You did good work here reverend. Just remember what we discussed, right? Keep the balance, aye?"
    $ sselectk = math.floor((pops - (gfai + lfai)) * .25)
    $ select = renpy.random.randint(0, sselectk)
    n "You feel closer to god and feel like you have converted [select] people."
    $ gfai += select
    $ clea += 1
    $ vege -= 2
    $ meat -= 2
    jump advance

label govisit:
    menu:
        "Where would you like to go?"
        "The Museum.":
            n "You decide to go visit the museum again. You knock on the door and you hear the multiple things fall, as before. The historians voice meekly bids you to enter."
            label askagainmuseum:
            menu:
                "What do you talk about?"
                "Just generally chat.":
                    sch "You talk about the goings on you've noticed in town, and the historian shares some interesting facts about the whaling industry. "
                    sch "Unbeknownced to you, this was a whaling port untill a few years ago. The carcasses would get dragged back out to sea once everything useful was harvested."
                    sch "You ask why you don't see more whale ivory here, but he says he dosen't know."
                    jump advance
                "Ask about Finikson." if knows_finikson is 1:
                    sch "\"W-w-w-where did you hear that name?!\" He stammers."
                    n "You think on it for a moment, then you describe the dream you had. His face lights up."
                    sch "\"Fascinating! You've had an encounter with the Lady of Weeds! I'll-I'll keep this between us, of course.\""
                    sch "\"This island was settled by Vikings in the 1000s, and there was tales of them bringing a religion here. Similar to the Queen we worshi- uh, who is whorshipped here, I guess.\""
                    sch "\"I don't know if it's real or not BUT!\" He holds up his hand. \"The Norse were meticulate record keepers. There was a Finikson expedition in 1012.\""
                    sch "\"If your dream is to be believed, and I think it is, she was brought here by that expedition in order to try and contain or imprison her.\""
                    sch "\"Researching The Lady of Weeds, or the Queen of Weeds, has been my entire career. There are several mythological water nymph/ladies of the lake this being could be.\""
                    sch "\"My Predescessor, Emmit Browns, thought that she might be Nimue, the Mythical Lady of the Lake from Arthurian lore. The timing dosen't match for the authoring of the lore...\""
                    sch "\"BUT she DOES show up in earlier poems by Chrétien and other authors, meaning she was already an ingrained part of folklore, and fairly positive one at that.\""
                    sch "\"It is my firm belief that she was taken captive by the Norse, and when they discovered they couldn't kill her or use her, they tried to get rid of her the only way they knew how.\""
                    sch "\"This also lines up firmly with stories from the native people of the time... unfortunatly, that's all I can say for now on that avenue. Hm.\" He looks thoughtful."
                    sch "\"If you can find that underground cave you mentioned, I would like to see it. Stories tell of divination methods they had to predict the lady's.. wrath. A bag of runes.\""
                    n "You take your leave, and leave the scholar in peace."
                    $ knows_runes = 1
                    $ knows_lady_of_weeds = 1
                    jump advance
                "Ask about the Lady of Weeds." if knows_lady_of_weeds is 1:
                    sch "\"N-n-n-nope. I-I-I'm sorry. We c-can't talk about that.\""
                    jump askagainmuseum
                "Ask about norse runes." if rubb is 1 and knows_norse_script is 0:
                    sch "\"This is it?! Wow. Ok. Uh... give me a couple of minutes.\" He reaches behind him and grabs a book, laying it open on the table."
                    sch "\"Ok, I've got some of this. Here's a rough translation:\""
                    n "In the year one thousand of the christian era, we left the port of Fagerlid with She of the Sea in chains to protect our shores from her influence. She of the Sea is a horrible monster from (hellas)greek myth, beset on us by the Brittons. Do not proceed past this point - she must not be allowed to escape."
                    n "If she has, there is one gift we have for you. In this chamber you will find our rune stones. She can only be defeated by faith in whatever god you choose. The runes will help you determine the tennants of your faith she will pull power from."
                    n "This is only effective if you are practicing one of the dominant religions of the area."
                    n "The cult of Noceia has sacrificed all of our resources to get her here. Do your duty, and ensure she stays. We know you are not here by choice, but your duty is the same. She must not escape. She will change things, the histories of people."
                    n "Preserve your faith, and you will be protected. If those you rely on are consumed, it is up to you to train those who come after."
                    n "The spell will not fail, but if you wish to spare others this fate, do your best."
                    sch "The scholar is very quiet once he's done. You both sit there for a moment."
                    sch "\"Greece? Huh. How... how did she get there from Greece? The Romans? No, it would have been Byzantine by then. I guess someone else figured out how to capture her.\""
                    sch "\"And we are what... fuel? Yeah, no one really leaves the island... well, except for the pastors...\" He's thoughtful for a minute. \"Huh.\" He closes the book and slides it towards you."
                    sch "\"Here. Take this. I... need to think on this for a bit.\""
                    $ knows_norse_script = 1
                    jump askagainmuseum
                "Ask about the church.":
                    sch "\"Ah, the church? That was an addition by the spanish in the 1500s. The quarried stones were taken from conquered south american coastal citiesm and it was errected finally in 1543.\""
                    sch "\"The stained glass and fittings were produced onsite, though the sheets themselves were shipped from spain. Three years after it was completed, a plauge whiped the settlement off the map.\""
                    sch "\"It was resettled in 1551. That settlement was more successful, lasting till the 1700s, though there were... some stories. Human sacrifices, that stuff.\""
                    sch "\"In 1812, the island was resettled from North America, though local history tells of a small group of settlers still living here. The graveyard was cleaned out and tossed to the sea, and the church fixed.\""
                    sch "\"It has been open and preaching every week since 1812, with one exception in 1915 when a lost french firggate shelled the island for a day or so, causing minimal damage.\""
                    sch "\"You are the.. 14th acting Reverend, and yes, I know this is a temporary placement, but still. Your placements are only 10 years here.\""
                    sch "\"There were catacombs underneath the church at some point, but they have been sealed for over a hundred years at this point. That's about all I can tell you.\""
                    $ knows_catacombs = 1
                    n "You thank him for the discussion, and take your leave."
                    jump askagainmuseum
                "Ask about painted cave." if knows_cave1 is 1:
                    sch "\"You found it! Amazing. Oh, I wish I had been there. Just before there is the foundations of a Viking era town.\""
                    sch "\"We don't have a lot of information on the town itself or why it's inhabitants left. It's located strangely inland - Vikings tended to prefer costal settlements.\""
                    if knows_lady_of_weeds is 1:
                        sch "\"But, we've already covered most of this when we talked about your dream. The painting is what interests me.\""
                        sch "\"My suspicion is that it's a warning about whatever is in that cave. Potentially, whatever they imprisoned the lady in.\""
                        sch "\"If you can get your hands on a shovel, I'd dig around in those ruins. Please bring me anything you find!\""
                        $ knows_shovel = 1
                    sch "\"I unfortunatly can't help you with a lantern - I wouldn't go in with just a candle. Preferably, a bullseye lantern.\""
                    sch "\"I'd check with Azmogold - he might be able to get one for you.\""
                    $ knows_lantern = 1
                    jump askagainmuseum
                "Ask about using the alternate ritual." if tantrum_alice is 1 and skill_history >= 3:
                    sch "\"Wh-wh-what ritual?! Hu-hu-human sacrifice! Y-y-you insult me!\""
                    n "You explain the events up at the church, and he slumps a bit."
                    sch "\"Wait here. I got to go talk to someone.\""
                    n "You wait. After what seems like a half hour, he returns with Asmund in tow. You then explain everything to Asmund."
                    asm "\"Well reverend. You might actually have something here. Congradulations. You get to meet the council. Paulie, open it up and ring the bell.\""
                    n "The historian reaches under the desk and pulls something. You hear lots of mechanical sounds, similar to the first time you entered. He reaches to the other side and pulls something else. Behind him, a bookcase moves."
                    n "Asmund pulls asside the bookcase, revealing a stairway behind. He beckons you down, and you follow."
                    n "You feel like you're descending down this stairway forever, before it suddenly opens to a large chamber. Five seats sit in the center of the room, with a raised platform with a counter and several seats along it. All but one are filled with robed figures."
                    n "Asmund gestures for you to sit, before taking his own seat."
                    asm "\"The Conclave is now in session. Reverened, you're familiar with me. Let me introduce you to the other members. To my right here, this is Caleb Douglas.\""
                    caleb "The man removes the hood. He has a moustache and red hair - he seems like the rough and tumble type. You notice his left eye is a cobalt blue, and he has a serious expression."
                    asm "\"Next to him, Ellie Page.\""
                    ellie "She is thin faced, with shock white hair. Her eyes are grey, impassionate."
                    asm "\"Next is our esteemed Doctor, and finally, Genna Emrich.\""
                    n "The Doctor does not remove his hood, but Gemma does. She's a older woman with glasses and a hard stare."
                    gemma "\"So, you have something for us, Reverend?\""
                    n "You explain that your religion forbids you from allowing one who asks for asylum to go do death, willing or not."
                    n "However, in your history books, you found something. A ritual that used to be used, requiring the whole town to participate."
                    n "The Doctor scoffs, but the rest of them are silent."
                    n "\"Of course. A story within a story. Only the Blacksmith would think of something so terse. No flair.\""
                    gemma "\"We are not going over that little feud of yours again. We have more pressing matters. Paulie, you're the historian, refresh my memory. I take it this was the 1921 ritual?\""
                    sch "\"Uh, aheh, 1921, 1919, and 1916. It failed in 1921.\""
                    gemma "\"That explains why it hasn't been done since. Caleb - are those three scientists still out at the old mannor house? If my memory serves, we need everyone to contribute to the offering.\""
                    caleb "Caleb Grunts. \"Yeah, they're still up there. They shot at Daniels with that fancy gun of thiers. They've done something to the locks on the front door. I've noticed they have more crates than... last time. In fact, every time they seem to have more.\""
                    gemma "\"Well, thank you for bringing us this solution Reverend, but, there's still the matter that this is an issue that YOU created. Ellie, is he aware of our... prediciment?\""
                    ellie "She looks at you hard, scrutinizing every detail."
                    if mp_data.patd_restarts >= 1:
                        ellie "\"Yeah, I saw him on the docks. I know that look. He remembers something.\""
                        gemma "\"So, as you have discovered, We're in a loop. One year and twelve days, usually. After you leave, the lady will throw a tantrum and try to escape. It always fails, but we all die in the process.\""
                        gemma "\"SOMETIMES, for whatever reason, you choose to stay and the Reverend does not return. We're not sure why this ocassionaly happens. Longest we know of is three years. The repeat is not... perfect.\""
                        gemma "\"We forget things. Sometimes, new people arrive at the island. The hippy in the stacks, the scientists over in the manor, the german soldiers and their U-boat. We learn some things. We also know that some people somehow escape.\""
                        gemma "\"WE exist to make sure that the Lady never gets out. She tortured the Norsemen for three hundred years before the Spanish found here and the Norse escaped. We replaced the spanish - that one was bad. The loop stopped but she was still bound.\""
                        gemma "\"It was almost twenty years before we got it back up and running. I am part of the third group to arrive. The Reverend you replaced - the one on vacation? He's fading. He'll soon escape. Then, you'll no longer arive by boat.\""
                        gemma "\"Ellie, Caleb and the Doctor came here from somewhere else. Asmund was a spy and a member of the British Thuule Society in the late 1800's. There's also another priest - an angry one.\""
                        gemma "\"We don't know where he came from, but he occasionally causes problems.\""
                    else:
                        ellie "\"No, seems to still be in the first ring.\""
                        gemma "\"That's a shame. We'll have more to talk about next time we meet.\""
                    gemma "\"Asmund, do we have enough food for the celebration?\""
                    asm "\"Yeah... but Eileen's not going to be happy.\""
                    gemma "\"After that little mold issue, she can be unhappy all the hell she wants. Fine. Reverend. You will keep Alice at the church. On the 60th day, we'll do the celebration. Go - we'll sort out the details.\""
                    gemma "\"We'll reach out and discuss this after it's all done.\""
                    $ tantrum_alice = 2
                    n "Paulie escorts you back to the surface, and you hear him lock the door behind him. You climb the hill back to the church and give Alice the good news. She is overjoyed, but still scared."
                    n "Time will tell, I guess, if this succeeds."
        "I think I'll actually go shopping instead." if mone <= 1:
            jump shoppingeach
        "Nah, this wasn't a good idea.":
            jump no_advance

label dream:
    n "You fall asleep..."
    with dissolve
    if day is 0 and segment is 0:
        show ladyofweeds at right
        with dissolve
        n "You are standing on an what appears to be an infinite flat plane. The ground appears to be mirrored, but at the same time is hard enough to support your weight. In front of you is a round table with several chairs, and seated in one of them is what appears to be what's left of a woman."
        n "Her skin is pulled taunt on her bones, and several pieces of seaweed and branches emerge from her dressing, which also appears to be made of weeds. Her gnarled, branchlike hands rest on the circular table. Her empty compound eyes lock onto you in an instant."
        n "\"Who… who are you? How do you know my name?\" You reply."
        n "Her head cocks at an odd angle, and a single hand gestures to one of the seats. You sit."
        n "\"I… I don't understand.\" You stammer."
        n "Her mouth opens, leading to a immense tunnel, filled with water, fish, and weeds. It closes and she smiles. Too big."
        n "\"Why? What do you hope to gain?\" You ask."
        n "A single hand lifts from the table and picks up a teacup… the table is now set for the two of you, and one other person. Her mouth opens way to far and she pours the tea in, similar to how a puppet would, then placing the cup gently down."
        n "\"She is not YOURS to claim.\" You exclaim, pointing at the figure."
        n "The smile goes from cheery to polite. A hand reaches up to the eye and pulls something out, before tossing it to the ground. The compound segments rearrange themselves like worms until they finally settle down."
        n "\"There doesn't need to be any more death. We can all coexist.\""
        n "She shakes her head, and points at you. You reply. Again, and again, and again. There are so many fish here, so many questions. You wake up."
        hide ladyofweeds
        with dissolve
    else:
        $ select = renpy.random.randint(1, 6)
        if select <= 3:
            show ladyofweeds at right
            with dissolve
            $ select = renpy.random.randint(1, 18)
            if select is 1:
                n "You are in the study of the church, and beside you stands a haunting figure. Her skin is taunt around bones, her eyes are compound segments like an insect, and she appears to be covered head to toe with branches, weeds, and seaweed. "
                n "She points at the desk, at a figure sitting there."
                n "For a brief moment… it looks like you. But it's not. The cut of the clothing is different. "
                n "He has what appears to be several small talismans made out of bone, covered in runes, which he throws onto the table and then writes down the outcome."
                n "\"I don't know where he hid them… I don't even know who that is!\" You exclaim."
                n "Her face becomes stern. Her eyes vibrate like snake rattles."
                n "\"That's impossible! No, I don't know anything about this.\" You say, as you try to walk away, but suddenly your feet are snared in place by vines from the floor, then ceiling. "
                n "They twist you around, so that you are forced to stare at the man."
                n "She points at the the talismans. Now you see they aren't bone… they're made of antler. Where the heck would you get antler here?"
                n "\"I… I don't know what you're talking about. What expedition? What Vikings?\" You say."
                n "Her frown deepens, and she vanishes. You are left there, watching not-you making predictions, for who knows how long. "
                n "When you wake, you feel like you haven't slept."
                $ mood = mood - 2
            if select is 2:
                n "You are in a luxorious dining room, standing at the opposite end of a large table. A porcine man, someone you have seen down by the docks, sits at the other, eating portions of a full suckling pig. There is another here."
                n "Standing in a doorway is a figure most dreadful. Her skin is stretched tight, and she appears to be cloaked in sticks, weeds, and seaweed. Some of them float up like she is underwater. She points at the man."
                n "\"Yes.\" You reply. \"It's called gluttony.\""
                n "Her smile widens, so much that it looks like her head might split in two. Her compound eyes dart around in the sockets, like they were worms… or fish."
                n "The man quickens his eating. He drops his knife and fork, preferring to use his hands."
                n "\"It's… it's because… when people hoard food… it will cause… others to go hungry. People starve and die because of another's greed.\" You say around the loud sounds of his eating."
                n "She looks at you, fully this time."
                n "\"Gold? Same principle… People trade gold for food and housing, without it you can't eat… or have a place to eat.\" You respond."
                n "There is a sickening crack. The man yelps, pulling something out of his mouth. It's a gold coin, with a piece of tooth embedded in it. He stares at it, transfixed."
                n "She looks over to him, and a second later, he swallows the coin. Now the food on the table is gone, replaced with a pile of gold coins. He eyes them greedily."
                n "\"What?! No! Please, stop this! You are not the judge of this man's sins! He must…\" You are cut off by the next sounds."
                n "One by one, he inserts the coins into his mouth and swallows, slow at first, then faster. His cheeks have swollen, and his eyes bulge from his skull. One after another, the coins go in. "
                n "Plop, suck. Plop, suck. Plop, suck."
                n "\"What have you done…\" You mutter."
                n "The man's chest expands. He shoves more into his mouth, and his shirt rips. His face is a painting of grotesque extasy. More and more coins go in, and he swells more and more. "
                n "His chair gives way and he falls to the floor, bringing the table down with him. The coins stay fairly central, but several scatter. "
                n "He dosen't even notice. More coins go in, and he swells more. You can hear several cracking sounds as his ribs rupture. "
                n "He shakes for a moment, then stuffs in more. And more. "
                n "Then, there is a popping sound."
                n "His chest splits open. Gore and coins spill out of his innards, and he starts shoveling handfulls into his mouth instead of pushing them back in his chest. "
                n "You are too horrified to speak. Something hits your boot. It's a blood covered coin. You look over at the woman."
                n "She is very close."
                n "She is smiling."
                n "When you awake, you find a single gold coin next to your bed, covered in blood."
                menu:
                    "What will you do with the coin?"
                    "Clean it up, then sell it.":
                        n "You wash off the blood and take it down to a salvage shop near the docks. It gets you ten pounds, but you feel awful."
                        $ mone = mone + 10
                        $ mood = mood - 10
                    "Toss it into the sea.":
                        n "You throw the coin off the cliff into the sea. You feel like you just dodged a curse."
                        $ mood = mood - 2
                n "There are no reports of deaths the next morning..."
            if select is 3:
                n "You are standing on a street. In front of you is a small Parisian café. A woman and a man sit there, drinking coffee. Beside you, you can feel something there. A figure who is becoming increasingly familiar."
                n "\"Was. She's dead now.\" You respond."
                n "The man gets angry. He's yelling."
                n "\"Could I? No. What's done is done. They're both dead. She died at his hands, and he died during the war.\" You grumble."
                n "It's different now. A different place. An apartment of some sort. They are yelling. She grabs a statue and throws it at him. It breaks into pieces on the wall behind you."
                n "\"No, I couldn't. This is another illusion of yours.\" You say, as you turn to look at her. It takes a tremendous amount of effort. You can see she's smiling."
                n "\"Are you done sifting through my memories? Let the dead rest. It's not our job to judge them, leave that to the saints.\""
                n "An eyebrow raises, then she waves a hand. You are standing at a grave, flower in hand. You place it."
                n "When you wake, you can still smell Evelyn's perfume. Even all these years later, it still hurts."
                $ mood = mood - 5
            if select is 4:
                n "You are in a mourge of some kind. There is a body on the metal table, with a cloth over it. Across from you stands a figure with taunt skin, dressed in sticks and weeds. Her hair and clothing floats up, as if she was underwater. She watches you."
                n "\"Oh. We're doing this again.\" you mutter."
                n "She smiles, then pulls back the sheet."
                n "It's David's body. His leg has been blown off below the knee, and he's missing both of his arns, and most of his head. You know it's him though… This though, is not a memory. He's interred in the military cemetery. "
                n "You signed for him, but never saw it. He's still caked in blood, mud, and gore."
                n "\"So, what? Yes, he's dead.\" You angrily say to the woman."
                n "She smiles wider."
                n "A sound comes from the corpse. The head tilts to you. Sounds… words."
                n "\"Wzzzzhy… wzhy diddnt you shtop me…. Why…\" it wheezes"
                n "You go from unamused to completely incredulous. \"What the hell is this? This the best you can do? Penny carnival scares! What. Do. You. Want.\""
                n "She smiles wider."
                n "\"Jjjju… need to pusht me baaahk togeshr. Gesht my armsh buuuhd.\" The corpse says."
                n "\"Fine.\" You say. \"We do this then.\" You reach into your collar, and thankfully your necklace is still there. You hold the silver and copper crucifix in-front of you, and begin to recite."
                n "\"In the name of Jesus Christ, I rebuke and break any curses, hexes, spells, demonic activity, or any other evil thing that has been sent against me!\""
                n "Her eyebrows furrow, and the facets of her eyes line up, vibrating slightly. With one hand, she reaches out and pokes the crucifix."
                n "\"I command Satan, in the Name of the Lord Jesus Christ, to leave my presence with all of his demons!\" You project."
                n "Then, there is an earthquake. The three of you are suddenly flying through the air."
                n "You wake up on the wooden floor, tangled in blankets. Someone is rapping on the door of the ministers quarters. Apparently, you have been yelling. You reassure them, then go back to bed."
                $ mood = mood - 5
            if select is 5:
                n "You are standing in some kind of underground arena. In the center is a large metal plate, with several chains attached to it. In the center, unchained, stands a woman. "
                n "Her skin is taunt against her bones, and she wears branches, weeds and seaweed like clothing. Her hair and pieces of her clothing float as if she is underwater. The ground is covered in bodies."
                n "\"Where are we?\" You ask."
                n "She shakes her head, and points. Suddenly, two of the bodies move. One has embedded his sword hilt deep into the other, and the other has embedded his axe into the neck of the first."
                n "\"Finikson?\" You confirm."
                n "This time, four bodies move. The axeman moves about three meters, and has lopped of the head of another man with a bow. The swordsman that killed him is on the other end of the room, skewering a man with a mace."
                n "\"Please, slow down. What is this?\" You ask."
                n "The bodies move again. The woman moves her arm as if she's conducting an orchestra. There are three people in the entrance, two who have been downed by arrows, and the third with an axe embeded in his torso. "
                n "The archer is on the other end of the room, and the man with the sword and the mace are rushing to confront the three."
                n "\"This is how it started? Why did they turn on each other?\" You ask."
                n "Then, everyone is back where they fell, and you are watching from the side of the room. The woman is there with you, and in the center of the room, shackled. "
                n "You watch as pieces of seaweed extend from her restraints and move into the quickly desiccating bodies. Soon, one twitches, and stands. In moments, they all do. "
                n "One retrieves a small silver key, and unlocks the woman's restraints. You watch as the key drops to the floor beside the platform. They all leave, and you wake up."
                if knows_runes is 1:
                    n "You have jsut enough prescence of mind to remember the conversation with the historian. Glancing around, you see it. A small leather bag, under a dropped shield, in a far corner. Covered with detrius."
                    $ knows_runes_loc = 1
                $ mood = mood - 1
                $ knows_finikson = 1
            if select is 6:
                n "You wake in the church. You recognize Reverend Evohart, sitting at a table with a chess board on it, and across from him… a woman clad in seaweed, sticks, and weeds. You recognize her immediately."
                n "They say nothing while they play. Nothing needs to be said."
            if select is 7:
                n "You are walking through the town with a Lady you have come to know well. She dresses in the best finery nature can make for her. All the townsfolk have drowned, but that's ok. It's bound to happen. "
                n "You take her dainty wooden hand, and lead her to the sea, then out to the deeps."
                n "You wake up sputtering."
                $ mood = mood - 2
            if select is 8:
                n "You are walking on the bottom of a dark ocean. The sand feels good between your toes, and far, far away, you can see a massive castle made of corral. "
                n "Hundreds of corpses, animated by seaweed, move along the bottom on tasks of their own, each stepping like they are on the moon. In a high tower, something glows, and you can feel something at the back of your neck pulling you towards the light."
                n "You wake up and decide to make some coffee."
                $ mood = mood - 2
            if select is 9:
                n "You wake chained to some kind of stone, standing vertical, stripped of all your clothes. All around you is a dark, misty void, save for a single shaft of light emerging from somewhere above. You struggle, but you find you can't move. Something shifts out in the darkness."
                n "It is the Lady of Weeds. Her skin is taunt against her face, garbed in seaweed, branches, and detritus. She floats through the air towards you. She stops a mere foot in front of you, before reaching out and placing her wooden talons gently onto your chest. You try to jerk away, but find that the chains pull tighter. "
                n "Slowly, she drags them down your chest to your stomach, while you jerk and scream. Her compound eyes bulge out, and they look like stalks of an anemone while this close."
                n "They go lower and lower, and you scream and curse. One goes between your legs, and she pulls it slowly forward, touching things she should not. You scream and cry, but it is of no use."
                n "You awake, terrified."
                $ mood = mood - 10
            if select is 10:
                n "You are standing in front of the ocean, beside an older woman. Several seaweed monsters stand in the surf, with an older man dressed in fishing waders between them."
                n "He looks up at her. \"We knew this day was coming, Selma. We had more time than we expected. I will always think of you. I love you.\""
                poorwm "*sob*"
                n "You watch as the monsters lead him into the sea, and he disappears beneath the waves. Even though she can't see you, you stay with Selma until you wake."
                $ mood -= 1
            if select is 11:
                n "You wake up, and you can feel something watching you. It's immediatly apparent that this is a dream, but you feel more in control than normal."
                n "Something makes a sound in the church. You rise and go through the door, and find that the church has been rearranged. The pews are stacked on the sides, and someone has set up a chessboard and two chairs."
                tem2 "A woman sits, wearing little other than a white hooded cloak."
                tem2 "\"Ah, Reverend! My appologies - I have co-opted this one. The lady is not ammused, but she allows me some... abilities. Far better than the standard dream, don't you think? Come. Sit.\""
                tem2 "You take a seat, and make your first chess move."
                tem2 "\"Reverend, while the Lady oberves everything that happens in these dreams, we can still speak freely here. I have... permission to make such arangements.\""
                tem2 "She makes a move on the board."
                tem2 "\"The arrangement I've come to talk about is of worshippers. See... everything we have here is like this board of chess.\""
                tem2 "You make a move."
                tem2 "\"As your predecessor informed you, it's all about balance. You make a move, then I do. Neither of us are playing to win.\""
                tem2 "She makes a move on the board."
                tem2 "\"Because... if one of us does... Bad things happen. I get too strong... the lady makes her move. You do... same thing, but more desperate. Survival.\""
                tem2 "You make a move."
                tem2 "\"From what I know, I figure we have [lfai] faithful, and your lot has [gfai] faithful. Everything we do, or don't do, changes this.\""
                tem2 "She makes a move on the board."
                tem2 "\"As is such... I'd like to keep an offer open. An arangement I had with your predecessor.\""
                tem2 "You make a move."
                ten2 "\"People in our possitions don't get to experience love. Passion. Heartache. In this place... well... We can enjoy one another without angering our chosen deity.\""
                ten2 "\"A work around, if you will. As long as we keep the chess game going. A girls got needs too, right?\""
                tem2 "She makes a move on the board."
                menu:
                    "What do you do?"
                    "Continue to play chess.":
                        n "You play untill the wee hours of the morning, and the dream ends. You feel strangely well rested."
                        $ mood += 10
                    "Indulge in more carnal desires.":
                        tem2 "You have had this dream many times. Her breasts are supple, and she is as soft and warm as you imagined. She smells of vanilla, and something floral you can't place. You experience an extacy you never thought you would."
                        n "TODO: Extend"
                        $ mood += 20
            if select is 12:
                n "You are standing in a stone cave, in front of a metal hatch. It appears to be freshly sealed, and the two men are engaging in a vicious argument."
                n "\"We can still fix this!\" The one in the black uniform says. \"You are sealing several decades of progress away with this foolhardy decision!\""
                n "\"Nate, it's done. Everyone else is dead!\" The other screams. \"This needs to die with us. Take off that stupid uniform and we can go back. He's never going to see reason.\""
                n "\"Stupid uniform!? We were so close - I almost got through to him. Why can't you see that!\" The black uniformed man screams. You notice him reaching for something at his belt."
                n "The man in the green uniform begins to leave, but all at once the man in the black uniform charges forward with a blade and embeds it in him. The other man screams, and whips his hand behind the head of the first."
                n "There is a spray of blood, and the man in the black uniform stumbles backwards. They both lay there, groaning, before both gurgling and growing quiet. There is a wrinkled hand on your shoulder."
                n "\"Why are you showing me this?\" You ask."
                n "You can feel her eyes blaze behind you as the wind blows outside the cave."
                n "\"This is not context. I don't know what this is.\" You tell her."
                n "You drift, in that cave, till morning takes you."
            if select is 13:
                n "The station rumbles again. You can do this. You're not too late. The hallway is one hundred meters - you make it to the end, past the security shutter. With a quick movement you press your ID against the reader, and the shutter slams closed."
                n "They were already dead. There's nothing else you can do. She can't escape again."
                n "The airlock wheezes open, and again, you secure it with your ID. It won't hold her forever. It never does. It just needs to hold her for long enough."
                n "The far side opens, you dash out, close it, and pull a vacuum once again in the center. Then, you're off again down the hall."
                n "The security office is on the left? No, the right. The door automatically opens on your approach, and you dash in, slamming your hand down on the emergency countermeasure button. There is a hand on your wrist, but it's too late."
                n "You’ve seen this form before. He, then she. You've seen almost all their forms over the years. This one they call the Judge. The eater of stories. The ender of worlds."
                n "The masculine hand presses against your wrist, and it dissolves. No blood, no viscera, just… gone."
                n "You scream."
                n "\"What did you think was going to happen, you insect?\" She sneers. \"You can't run, you can't hide.\""
                n "You watch the lights on the console out of your peripheral vision. One blue, one red, one solid green, one blinking green. You still need time."
                n "\"I don't have to. I just need to outlast YOU.\" You shout."
                n "\"You never do though. How many times have we done this, over and over again, and each time I still. Kill. You.\" He whispers, stepping closer."
                n "Two solid green, one blinking green. Almost there."
                n "\"The thing you vampires don't understand is that I don't have to survive. I come back, each time the cycle starts again. The Blacksmith was right - for as much as you remember, you never learn.\""
                n "Three solid. Victory. You involuntarily chuckle, and she scowls."
                n "\"Don't you ever say that name to me.\" He growls"
                n "\"That's the best part of this. You escape? You'll create him again, he'll trap you again. Again, and again, and again. Just like us. He'll die so that everyone else can live.\""
                n "\"I tire of you.\" She growls, before plunging a fist into your chest."
                n "You gasp. The lights of the station dim, and you feel the gravity lighten. Dampeners are offline. We're out of range. He looks around, and at the control panel as the screens start to flicker."
                n "\"Check… mate.\" You sputter."
                n "The last thing you hear are her screams, left in the dark."
            if select is 14:
                n "You take another sip of the scotch, before flipping back to the file."
                n "Five disappearances over twenty years, always either on the sea or land in South-east Prince Edward island, starting in 1946. Last one was a Canadian military naval officer on vacation with his family, went out on a speedboat and never came back."
                n "A reporter that was investigating a canning factory with elevated levels of tin in the product. Two teenagers on spring break, three years apart. A boy and a girl. Twenty-one and Seventeen."
                n "Finally, a survivalist instructor, didn't report in during a safety check with his daughter."
                n "Each site was completely wiped clean, down to the sand. The speedboat just disappeared. The reporter's car was found at the side of the ocean with all the windows, and strangely, both headlights broken."
                n "The camp site for the girl was found based on conversations with her friend, but the campsite of the boy was not."
                n "Each site on land had clear signs of dragging, all the way to the side of the ocean. So what were these - abductions?"
                n "The kids fit the bill of trafficking. The other three though? The reporter was a World War 2 vet, knew hand to hand combat. Same with the military officer."
                n "His boat could have sunk at sea and he could be unrelated… but your gut tells you that's not the case."
                n "Curious, you go back to your records and find your disappearances scrap book."
                n "Hm… more. There was several disappearances in the early 40s from the same area. A pastor in the 30s. Three dockworkers on a fishing trip, and several different people in the 20s. All somewhere around Talfin Bay."
                n "You take a sip of your drink, and pick up the receiver of the phone."
                n "\"4146. Please connect me with the archives. Western Island Tribune.\" The line clicks several times, and a voice on the other end answers."
                n "\"Evening, this is PI A. Mallory, I'm hoping to get some assistance. I'm looking for records on disappearances around Talfin Bay pre-1920s. Any records you can find. I understand. Account? 1282. Yeah, I'll stop by and pick it up on Friday. No rush. Yeah, cold case. Thank you.\""
                n "Ok, think. Let's eliminate the Environmental issue. You grab a book of topographical maps from your bookcase and place it onto the desk."
                n "Talfin bay is fairly isolated, so not much of a chance of rip tide. Storms would scour or bury the camp sites, but according to reports it looks like they were purposefully cleaned. Storms don't do that. People do that."
                n "Your eyes rest on a note left in one of the margins:"
                n "\'Danger: Fog in early mornings and evenings. Docking may not be possible at all times. Please choose alternate route in inclement weather.\'"
                n "Well, that still doesn't mean the Military officer didn't run aground. Fog though - if its so routine that they have to put a map note, then it must be bad."
                n "This would make the bay perfect for other activities, such as smuggling."
                n "There's only one way to know for sure. In the morning, you're going to go and do a little walk around of your own."
            if select is 15:
                n "You feel awful."
                n "The fog is thick as pea soup. You don't want to be here. Yes, St. Martin has been without a priest since the great storm, but with all the conflict of The Great War, this is the last place you want to be."
                n "No roads. Of course there were no roads. So, sea it was."
                n "\"Be brave!\" Cardinal Clarke told you."
                n "Bravery sucks. The ocean sucks. Small towns suck. The great war sucks. Rationing sucks. And now you're here to go preach to a bunch of barely literate fishermen."
                n "You were destined for the colleges in Rome, a life of servitude and greatness in His glory!"
                n "Now though, you're doing outreach to a small, squalid town of people the rest of the world doesn't care if lives or dies."
                n "Week after week preaching to these inbred bastards not to bugger their mothers and sisters. You spit in disgust, and your stomach reels again."
                n "The boat rocks harder, the wind coming out of nowhere. Now it's raining, and winding. Great. You press yourself against the wooden wall of your cabin and groan. It just won't let up."
                n "Damned him. Cardinal Clarke, you backstabbing prick. This is what you wanted. Getting rid of the up and comer, eh? Well, I'll show you. I'll show all of them."
                n "The boat lurches again, this time listing at a 45 degree angle. You feel pressed into the floor. Shouting on the deck. You stumble up to the portcullis, but can only see rain blowing sideways and that fog. You feel sick."
                n "A bucket and several loose bottles are finally taken by gravity and clatter to the other side of the cabin. More shouting. You stumble, gripping the bed, and reach for a life jacket. The hard foam slips over your head, and you struggle to do the string."
                n "The deck lists more, and you grab the bed. Cabinets open, their contents clattering over the room. You lose your footing. You fall. Or the boat falls. Hard to tell. Then, darkness."
            if select is 16:
                n "You are... somewhere. It kinda looks like the main thuroughfare of town, but the buildings are... wrong."
                n "You pass building after building, but none of them are familiar. Finally you come to a large iron gate. It swings open slightly on your approach."
                n "Ahead is an omnious house - just seeing it makes your skin crawl. In front of it though is a tree."
                n "Hundreads, thousands of strings hang from this tree, each knotted into it's own unique pattern. You feel drawn, but you can't approach."
                n "The lines and knots burn your brain. It's so familiar."
                n "You've been here before. Yeah, You, and Asmund. There was three others."
                n "You did something. Changed something. Something went wrong the original architects didn't expect."
                n "What did you change? You don't know. It must not have worked."
                n "You awake with no answers."
            if select is 17:
                outom "\"You really think this is going to work, Clarke?\""
                ouclarke "\"It has to. It's technically an infinite space wrapped around a singularity. Genius, really.\""
                ouclarke "\"I mean, if we ever have another big bang style interaction it'll be sheared off our reality, but at that point, I think we got bigger problems.\""
                outom "\"It's amazing they came up with this over a five hundred years ago.\""
                n "You look over the table. You and your crew have mapped most of Talfin Bay, and from what you've calculated, the entrance should be somewhere near. You should be almost on top of it."
                oupaulo "\"Do you think it's underground, then?\""
                ouclarke "\"Nah. Sensors say that there's a 10% difference between the weight of the sample on the roadway versus the beach.\""
                ouclarke "\"We'd expect a 4-5% margin, but not a 10. It's not underground or else when the hole opens, it would eat all the soil nearby.\""
                oupaulo "\"So, you're thinking magic then?\""
                ouclarke "\"If so, it's powered from within the rift. Dive teams found nothing on all four expeditions. Might even been woven into the spell, too.\""
                oupaulo "\"How so?\""
                ouclarke "\"Think of it like programming, right? You have a sensor, and then a rope with several spell knots. When the input is triggered, the spell knot fires. Or multiple spell knots fire. I wonder if it's replacing people…\""
                oupaulo "\"Replacing PEOPLE?\""
                ouclarke "\"Yeah, think about it. What if the spell is powered by the people inside, right? If one escapes, or manages to permanently die, they got to be replaced.\""
                ouclarke "\"So, the spell fires, and abducts the closest viable candidate. Remember the Uboat report?\""
                outom "\"The one that hit Newfoundland?\""
                ouclarke "\"Yeah, that one. They thought they rounded up all the crew, but there were three men not accounted for. What if they were abducted? It happened somewhere near here.\""
                n "You rub your face shield, near the bridge of your nose. After a moment, your hand drops down again."
                outom "\"How do we get in then?\""
                n "The man to your right pulls out a notebook, and flips it open to a page."
                oupaulo "\"Remember Tungusta IV? Yeah, I know that entire expedition was cursed, but we learned something. Rope knot 'sensors' tend to be more sensitive, causing them to be able to be overloaded.\""
                oupaulo "\"So, strategy is this. We got A2240 here - it's a low risk Aberrant Object, We put the crate on the beach, then set the feedback loop knot spell up, throw it in, and as soon as one of us get within twenty feet of the crate, should trigger.\""
                outom "\"Ok, lets go then. Paulo, grab the crate and put it in the target. You got the spell Clarke?\""
                ouclarke "\"Yup.\""
                n "The three of you leave the tent. The one you referred to as paulo retrieves a metal crate from the truck and hauls it down to the beach. He places it, and then retreats, before Clarke approaches and sets down the rope and retreats."
                n "The three of you stand for a few minutes, but nothing happens."
                ouclarke "\"Did we do it wrong?\""
                n "You break from the group and approach, but realize your mistake almost immediately. Five steps away, you fall to your knees. The sky has darkened, and you feel very heavy. To the south, over the water, you can see… trees? No, they're not over the water. They're in the same place!"
                n "You struggle up and turn around, before you realize your next mistake. The trees are appearing everywhere. Palao and Clarke are struggling to get to the truck, but you can already see it's too late. You were expecting a small portal. You were wrong."
                n "Everything goes dark."
            if select is 18:
                scene bg blackhole
                n "You are standing on the bridge of some kind of freight ship. The overhead lights are flashing in ways you've never seen electric lights flash before, and the entire room is a cacophony of loud, inconsistent noises. You are surrounded by men and women in white sailor looking uniforms, running between banks of gauges."
                n "You get the immediate feeling that you're supposed to be doing something, so you quickly run up to an open bank of levers and gauges."
                n "You can't make out what the heck is going on. All of the gauges are glowing, and the text moves on it's own accord. You use a finger to try and track SOME words to be able to read, but you're not fast enough. The sailor on your left makes a grunt of disgust, before pointing to two levers."
                n "\"Pull the stabilizers. Those two. Now, and hold them up. Come on! Hurry!\""
                n "So, you do as your told. There are buttons at the top of each lever, which you make sure not to touch. You hold them up, and take a look around. Everyone is still running around and there is a cacophony of noise and colors."
                n "A man in what appears to be a captain uniform points towards you and says something, before going back to giving out orders."
                n "Finally, you take a look out the window. The image you see doesn't make sense."
                n "The sky is the ground, swirling around. Images of sailing ships appear and disappear throughout the chaos, and at the far side of the maelstrom you see another ship heading straight for you. Fast."
                n "In a few moments, it's all over. You awake screaming."
            if select is 19:
                pass
            if select is 20:
                pass
            if select is 21:
                pass
            if select is 22:
                pass
            if select is 23:
                pass
            if select is 24:
                pass
            if select is 25:
                pass
            if select is 26:
                pass
            if select is 27:
                pass
            if select is 28:
                pass
            if select is 29:
                pass
            if select is 30:
                pass
            if select is 31:
                pass
            if select is 32:
                pass
            if select is 33:
                pass
            if select is 34:
                pass
            if select is 35:
                pass
            if select is 36:
                pass
            if select is 37:
                pass
            if select is 38:
                pass
            if select is 39:
                pass
            if select is 40:
                pass
            if select is 41:
                pass
            if select is 42:
                pass
            if select is 43:
                pass
            if select is 44:
                pass
            if select is 45:
                pass
            if select is 46:
                pass
            if select is 47:
                pass
            if select is 48:
                pass
            if select is 49:
                pass
            if select is 50:
                pass
            if select is 51:
                pass
            if select is 52:
                pass
            if select is 53:
                pass
            if select is 54:
                pass
            if select is 55:
                pass
            if select is 56:
                pass
            if select is 57:
                pass
            if select is 58:
                pass
            if select is 59:
                pass
            if select is 60:
                pass
            hide ladyofweeds
            with dissolve
        else:
            n "You sleep a deep sleep."
            $ mood = mood + 5
    jump dreamend

label travel_priestacc:
    $ WEATHER = "bright and sunny"
    n "Your residence is a simple affair - a goose down single bed, with a kitchenette, a sink, and an ice box across from it. The far corner is a combination iron stove/oven, which is set up to heat both your residence and the church building on the other side of the wall"
    n "The fourth corner has your desk, and two bookcases filled with books. Above the desk is a window looking out over the ocean."
    n "Looking through, the weather is [WEATHER]."
    menu:
        "What do you want to do?"
        "Read a book?":
            call door_and_walking from _call_door_and_walking_12
            jump library
        "Go into the church.":
            jump travel_church
        "Go out into the yard.":
            jump travel_yard
        "Work on your sermon?":
            call door_and_walking from _call_door_and_walking_13
            jump sermon
        "Do misc upkeep tasks?" if laun >= 1:
            call door_and_walking from _call_door_and_walking_14
            jump laundry
        "ALPHA: Switch to the old menu system":
            $ alphamenu = 0
            jump segment_choice

label travel_church:
    $ WEATHER = "nice and clean"
    n "The church is more ornate then your living arrangements - ten pews standing in front of a pulpit, a simple piano, an altar, and a large wooden statue of the cross. Several beautiful stained glass windows hang in sils depicting the positions of the cross."
    n "The church is presently [WEATHER]"
    menu:
        "What do you want to do?"
        "Clean the church?" if clea >= 1:
            call door_and_walking from _call_door_and_walking_15
            jump clean
        "Go into the Priest Accomidations.":
            jump travel_priestacc
        "Go out into the yard.":
            jump travel_yard

label travel_yard:
    $ WEATHER = "bright and sunny"
    n "The yard is free and clean. There is a graveyard(graveyard status selector) surrounded by a fence(fence status selector). Paths lead to the north down into the forest along the cliffs, and to the east to town."
    n "The weather is [WEATHER]."
    menu:
        "What do you want to do?"
        "Go for a walk in the forest?":
            call door_and_walking from _call_door_and_walking_16
            jump woods
        "Go into town." if segment is 0 or segment is 1 or segment is 2:
            jump travel_town
        "Repair the church?" if (grav >= 1 or mbui >= 1 or fenc >= 1) and wood > 0:
            call door_and_walking from _call_door_and_walking_17
            jump cproperty
        "Go harvest some wood?" if segment is 0 or segment is 1 or segment is 2:
            call door_and_walking from _call_door_and_walking_18
            jump chopwood
        "Go chop some boards?" if raw_wood >= 2:
            call door_and_walking from _call_door_and_walking_19
            jump mill
        "Go into the church.":
            jump travel_church
        "Go into the priest residence.":
            jump travel_priestacc

label travel_town:
    n "You walk into the town. (townstatus here)"
    menu:
        "What do you want to do?"
        "Go for a walk in town?":
            call door_and_walking from _call_door_and_walking_20
            jump events
        "Go talk to someone?" if (segment is 0 or segment is 1 or segment is 2) and knows_buildings >= 1:
            call door_and_walking from _call_door_and_walking_21
            jump govisit
        "Go buy some stuff?" if (segment is 0 or segment is 1) and mone >= 1:
            call door_and_walking from _call_door_and_walking_22
            jump shoppingeach
        "Go back to the church.":
            jump travel_yard
        "Feed the poor?":
            if vege <= 8 or meat <= 8:
                menu:
                    "Are you sure? You may not have enough food to make it till next week."
                    "No.":
                        jump travel_town
                    "Yes.":
                        pass
            call door_and_walking from _call_door_and_walking_23
            jump feedthepoor

label endingz:
    n "The stress is too much. You snap."
    n "You can't do it anymore."
    n "The cliffs are beautiful at this hour. It's peaceful."
    n "You feel at peace. Something you have been lacking."
    n "The wind billows through your hair as you fall. It feels good."
    n "The end is quick. Peaceful."
    jump gameend

label endingy:
    n "You have been feeling something coming on, your pain growing day by day for the last week."
    n "You crawl into bed with some warm tea, but it is too little to late."
    n "You never wake up."
    jump gameend

label endingx:
    n "You fall out of bed, the empty amber bottles toppling everywhere. They're everywhere."
    n "It's coming again. You need more. Your shaking hands go from bottle to bottle, never getting more than a drop."
    n "You had another somewhere here. You know it."
    n "Nothing but empty bottles. Nothing."
    n "WAIT!"
    n "One bottle, seal still on. You break it, and down the whole thing. The waves take you, and you slip off into blissful ignorance for the final time."
    jump gameend

label endingw:
    n "You are woken by screaming from the church and the sound of splintering wood. You jump up and  dash through the door, tripping and falling over something ropey on the ground."
    n "Weeds."
    n "There are immediatly weeds all over you. You feel pain as hundreds of talons dig into your skin through your pajamas, and the weeds tighten like a net around you. You scream, and are quickly dragged out into the courtyard."
    n "Someone else is nearby, struggling and screaming. Alice."
    n "\"Hold on!\" You scream. \"I'm going to get us out of this!\""
    n "You begin reciting prayers loudly. You grasp the cross hanging around your neck. It's painfully hot. You are dragged down the path, and are soon on the beach."
    n "You can smell burning, hear screaming. The Town! You continue fighting, but you're soon underwater. You kick and swim... but you don't last long."
    jump gameend

label endingv:
    n "Your eyes flitter open. You are standing on the edge of the cliffs. You hear the screams of the town below, but you can't look away."
    n "The warmth covers you, sets you at ease. It feels good in the cold air."
    n "More screams. You hear your name, but you can't break away. The warmth burns away your bedclothes, envelops you. Cleans you."
    n "Soon, your hair is gone. It's freeing. Then your skin. Your muscles. Your bones."
    n "You're free."
    n "{i}Thank you for playing! This is the end of the demo.{/i}"
    n "{i}Please reach out to help@nief.ca and let us know you're thoughts, or if there's a issue you experienced.{/i}"
    n "{i}Please make sure you mention that you were playing demo 0.0.1f.{/i}"
    jump gameend

label endingf:
    n "You wake up to a knocking on the door, and rise to find Asmund standing outside."
    asm "\"Good morning, reverend. I have news - Reverend Evohart will be back today. It is time for you to go.\""
    n "You thank him, and begin packing your things. It does not take as much time as you hoped."
    n "Soon, you and the crates full of your things are sitting on the dock, waiting for the boat."
    n "You would be lying if you were'nt eager to get out of this place. The things that you have seen will stick with you."
    n "However, you'd also be lying if you said you didn't enjoy the challenge. It's a shame you have to go. Halifax, Boston or London will never challenge you so."
    n "The boat pulls up to the dock, and Evohart steps off. He approaches, you shake hands, and he hands you an envelope."
    n "You put it inside your jacket. He nods. So do you. No words need to be said."
    n "This is no longer your vigil."
    n "You step onto the boat and take your seat."
    n "You will find your place someday, but it is not here."
    jump gameend

### Credits
### -Ovani Sound-
### Foley SFX

